/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.info;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import pregenerator.base.api.Align;
import pregenerator.base.api.IRenderHelper;
import pregenerator.base.api.TextUtil;

public interface IRenderObj {
    public float height();

    @OnlyIn(value=Dist.CLIENT)
    public void render(IRenderHelper var1, float var2, float var3, float var4, float var5);

    public boolean onClick(int var1, int var2);

    public static IRenderObj text(String text) {
        return IRenderObj.text((Component)TextUtil.translate(text));
    }

    public static IRenderObj text(String text, Align align) {
        return IRenderObj.text((Component)TextUtil.translate(text), align);
    }

    public static IRenderObj text(String text, Object ... args) {
        return IRenderObj.text((Component)TextUtil.translate(text, args));
    }

    public static IRenderObj text(Component text) {
        return new Text(text, Align.START);
    }

    public static IRenderObj text(Component text, Align align) {
        return new Text(text, align);
    }

    public static IRenderObj text(Component text, Align align, float height) {
        return new Text(text, align, height);
    }

    public static IRenderObj bar(String text, float progress) {
        return IRenderObj.bar((Component)TextUtil.translate(text), progress);
    }

    public static IRenderObj bar(String text, Object first, float progress) {
        return IRenderObj.bar((Component)TextUtil.translate(text, first), progress);
    }

    public static IRenderObj bar(String text, Object first, Object second, float progress) {
        return IRenderObj.bar((Component)TextUtil.translate(text, first, second), progress);
    }

    public static IRenderObj bar(String text, Object first, Object second, Object third, float progress) {
        return IRenderObj.bar((Component)TextUtil.translate(text, first, second, third), progress);
    }

    public static IRenderObj bar(Component text, float progress) {
        return new Bar(text, progress);
    }

    public static IRenderObj bar(Component text, float progress, float height) {
        return new Bar(text, progress, height);
    }

    public static IRenderObj padding(float height) {
        return new Padding(height);
    }

    public static float height(Iterable<IRenderObj> elements) {
        float totalHeight = 0.0f;
        for (IRenderObj obj : elements) {
            totalHeight += obj.height();
        }
        return totalHeight;
    }

    public static class Text
    implements IRenderObj {
        Component text;
        Align align;
        float height;

        public Text(Component text, Align align) {
            this(text, align, 5.0f);
        }

        public Text(Component text, Align align, float height) {
            this.text = text;
            this.align = align;
            this.height = height;
        }

        @Override
        public float height() {
            return this.height;
        }

        @Override
        public void render(IRenderHelper helper, float x, float y, float width, float scale) {
            helper.drawText(x, y, this.align, this.text);
        }

        @Override
        public boolean onClick(int mouseX, int mouseY) {
            return false;
        }
    }

    public static class Bar
    implements IRenderObj {
        Component text;
        float progress;
        float height;

        public Bar(Component text, float progress) {
            this(text, progress, 6.0f);
        }

        public Bar(Component text, float progress, float height) {
            this.text = text;
            this.progress = progress;
            this.height = height;
        }

        @Override
        public float height() {
            return this.height;
        }

        @Override
        public void render(IRenderHelper helper, float x, float y, float width, float scale) {
            helper.drawProgressBar(x, y, width, this.height, this.progress, this.text);
        }

        @Override
        public boolean onClick(int mouseX, int mouseY) {
            return false;
        }
    }

    public static class Padding
    implements IRenderObj {
        float height;

        public Padding(float height) {
            this.height = height;
        }

        @Override
        public float height() {
            return this.height;
        }

        @Override
        public void render(IRenderHelper helper, float x, float y, float width, float scale) {
        }

        @Override
        public boolean onClick(int mouseX, int mouseY) {
            return false;
        }
    }

    public static abstract class Interactable
    implements IRenderObj {
        private static final float SCALE = 2.0f;
        List<AbstractWidget> interactables = new ObjectArrayList();

        protected <T extends AbstractWidget> T addChild(T listener) {
            this.interactables.add(listener);
            return listener;
        }

        @Override
        public void render(IRenderHelper helper, float x, float y, float width, float scale) {
            float invScale = 1.0f / (scale *= 0.5f);
            Minecraft mc = Minecraft.getInstance();
            int mouseX = (int)(mc.mouseHandler.xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth() * (double)invScale);
            int mouseY = (int)(mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight() * (double)invScale);
            GuiGraphics graphics = helper.getGraphics();
            PoseStack matrix = graphics.pose();
            matrix.pushPose();
            matrix.scale(0.5f, 0.5f, 0.5f);
            this.setupInteractables(x, y, width, scale, 2.0f);
            int m = this.interactables.size();
            for (int i = 0; i < m; ++i) {
                this.interactables.get(i).render(graphics, mouseX, mouseY, 0.0f);
            }
            matrix.popPose();
        }

        @Override
        public boolean onClick(int mouseX, int mouseY) {
            mouseX = (int)((float)mouseX * 2.0f);
            mouseY = (int)((float)mouseY * 2.0f);
            int m = this.interactables.size();
            for (int i = 0; i < m; ++i) {
                if (!this.interactables.get(i).mouseClicked((double)mouseX, (double)mouseY, 0)) continue;
                return true;
            }
            return false;
        }

        public abstract void setupInteractables(float var1, float var2, float var3, float var4, float var5);
    }
}

