/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import pregenerator.PregenConfig;
import pregenerator.base.api.TextUtil;
import pregenerator.client.ProcessorRenderer;
import pregenerator.client.gui.PregenMenu;
import pregenerator.client.helpers.AddTabEvent;

public class ClientHandler {
    public static final ClientHandler INSTANCE = new ClientHandler();
    public ProcessorRenderer processor = new ProcessorRenderer();
    @OnlyIn(value=Dist.CLIENT)
    KeyMapping uiKey;

    public void onInfoPacketReceived(byte[] data) {
        this.processor.onInfoPacketReceived(data);
    }

    public void addFunctions(IEventBus bus) {
        bus.addListener(this::registerKeys);
        bus.addListener(this::registerOverlay);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerKeys(RegisterKeyMappingsEvent event) {
        this.uiKey = new KeyMapping("Options Gui", 73, "Chunk-Pregenerator");
        event.register(this.uiKey);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onDecorationAdded(AddTabEvent event) {
        if (ModList.get().isLoaded("pregen_expansion") || !PregenConfig.INSTANCE.previewInfo.get()) {
            return;
        }
        event.getHelper().addChild((LayoutElement)new ExtendedButton(0, 0, 210, 18, (Component)TextUtil.translateStyled("gui.chunk_pregen.button.preview", ChatFormatting.GOLD), T -> this.openPreview(Minecraft.getInstance().screen)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openPreview(Screen parent) {
        Minecraft mc = Minecraft.getInstance();
        mc.setScreen((Screen)new ConfirmScreen(T -> {
            PregenConfig.INSTANCE.previewInfo.set((Object)false);
            PregenConfig.INSTANCE.save();
            if (T) {
                String s = "https://github.com/TinyModularThings/Chunk-Pregenerator-Issue-Tracker";
                mc.setScreen((Screen)new ConfirmLinkScreen(open -> {
                    if (open) {
                        Util.getPlatform().openUri(s);
                    }
                    mc.setScreen(parent);
                }, s, true));
                return;
            }
            mc.setScreen(parent);
        }, (Component)TextUtil.translate("gui.chunk_pregen.missing_screen.header"), (Component)TextUtil.translateStyled("gui.chunk_pregen.missing_screen.body", ChatFormatting.GRAY), (Component)TextUtil.translate("gui.chunk_pregen.missing_screen.wiki"), (Component)TextUtil.translate("gui.chunk_pregen.missing_screen.back")));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyPressed(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        if (this.uiKey.isDown() && mc.screen == null) {
            mc.setScreen(PregenMenu.MENU.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerOverlay(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"chunkpregen", (String)"pregen_overlays"), (gui, partialTick) -> {
            this.processor.onUIRenderer(gui);
            GlStateManager._enableDepthTest();
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onInput(InputEvent.MouseButton.Pre event) {
        int mouseY;
        int mouseX;
        Minecraft mc = Minecraft.getInstance();
        if (event.getButton() == 0 && event.getAction() == 1 && mc.screen instanceof ChatScreen && this.processor.onClick(mouseX = (int)(mc.mouseHandler.xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth()), mouseY = (int)(mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onUIUpdate(ClientTickEvent.Post event) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        this.processor.update();
    }
}

