/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.PregenButton;

public class PregenCheckBox
extends PregenButton {
    private static final ResourceLocation SELECTED_SPRITE = ResourceLocation.parse((String)"chunkpregen:textures/gui/sprites/widget/checkbox_selected.png");
    private static final ResourceLocation HIGHLIGHTED_SPRITE = ResourceLocation.parse((String)"chunkpregen:widget/checkbox_highlighted");
    private static final ResourceLocation SPRITE = ResourceLocation.parse((String)"chunkpregen:widget/checkbox");
    CheckboxState state;

    public PregenCheckBox(int x, int y, int width, int height, Component text, boolean isChecked, Button.OnPress handler) {
        this(x, y, width, height, new CheckboxState(false, isChecked, text, arg_0 -> ((Button.OnPress)handler).onPress(arg_0)));
    }

    public PregenCheckBox(int x, int y, int width, int height, CheckboxState state) {
        super(x, y, width, height, state.getLabel(), null);
        this.state = state;
        this.state.setOwner(this);
    }

    @Override
    public void onPress() {
        this.state.toggle();
    }

    public boolean isChecked() {
        return this.state.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.state.setChecked(isChecked);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.blitSprite(this.getTexture(), this.getX(), this.getY(), this.width, this.height);
        if (this.isChecked()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SELECTED_SPRITE);
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            BasePregenScreen.drawTextureRegion(graphics, this.getX() + 1, this.getY() + 1, 1.0f, 1.0f, this.width - 2, this.height - 2, 18.0f, 18.0f, 20.0f, 20.0f);
        }
        if (this.state.showLabel) {
            Font font = Minecraft.getInstance().font;
            float xPos = this.state.horizontal.align(this.getX(), this.width + 2, font.width((FormattedText)this.getMessage()));
            Align align = this.state.vertical;
            float f = this.getY();
            float f2 = this.height + 2;
            Objects.requireNonNull(font);
            float yPos = align.align(f, f2, 9.0f);
            graphics.drawString(font, this.getMessage(), (int)xPos, (int)yPos, 0xE0E0E0 | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }
    }

    private ResourceLocation getTexture() {
        return this.isHovered() ? HIGHLIGHTED_SPRITE : SPRITE;
    }

    public static class CheckboxState {
        boolean showLabel;
        boolean isChecked;
        Component label = TextUtil.empty();
        PregenCheckBox owner;
        Consumer<PregenCheckBox> listener;
        Align vertical = Align.CENTER;
        Align horizontal = Align.END;

        public CheckboxState() {
        }

        public CheckboxState(boolean isChecked) {
            this.isChecked = isChecked;
        }

        public CheckboxState(boolean showLabel, boolean isChecked) {
            this.showLabel = showLabel;
            this.isChecked = isChecked;
        }

        public CheckboxState(boolean showLabel, boolean isChecked, Component label) {
            this.showLabel = showLabel;
            this.isChecked = isChecked;
            this.label = label;
        }

        public CheckboxState(boolean showLabel, boolean isChecked, Component label, Consumer<PregenCheckBox> listener) {
            this.showLabel = showLabel;
            this.isChecked = isChecked;
            this.label = label;
            this.listener = listener;
        }

        public CheckboxState withLabel(boolean value) {
            this.showLabel = value;
            return this;
        }

        public CheckboxState setChecked(boolean checked) {
            this.isChecked = checked;
            return this;
        }

        public CheckboxState withListener(Consumer<PregenCheckBox> listener) {
            this.listener = listener;
            return this;
        }

        public CheckboxState withStateListener(Consumer<Boolean> listener) {
            this.listener = T -> listener.accept(T.isChecked());
            return this;
        }

        public CheckboxState vAlign(Align align) {
            this.vertical = align;
            return this;
        }

        public CheckboxState hAlign(Align align) {
            this.horizontal = align;
            return this;
        }

        public CheckboxState setLabel(Component label) {
            this.label = label;
            if (this.owner != null) {
                this.owner.setMessage(label);
            }
            return this;
        }

        void setOwner(PregenCheckBox owner) {
            this.owner = owner;
        }

        public PregenCheckBox getOwner() {
            return this.owner;
        }

        public Component getLabel() {
            return this.label;
        }

        public boolean isChecked() {
            return this.isChecked;
        }

        public boolean showLabel() {
            return this.showLabel;
        }

        public void toggle() {
            boolean bl = this.isChecked = !this.isChecked;
            if (this.listener != null && this.owner != null) {
                this.listener.accept(this.owner);
            }
        }
    }
}

