/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import pregenerator.base.api.Align;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.PregenButtonGroup;

public class PregenButton
extends Button
implements BasePregenScreen.ITooltipProvider {
    protected Function<PregenButton, Component> tooltip;
    protected PregenButtonGroup group;
    int hash;

    public PregenButton(int xPos, int yPos, int width, int height, Component displayString, Button.OnPress handler) {
        super(xPos, yPos, width, height, displayString, handler, DEFAULT_NARRATION);
        this.hash = displayString.getString().hashCode();
    }

    public PregenButton setTooltip(Component tooltip) {
        return this.setTooltip(tooltip == null ? null : T -> tooltip);
    }

    public <T extends PregenButton> PregenButton setTooltip(Function<T, Component> tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public void onPress() {
        if (this.onPress != null) {
            this.onPress.onPress((Button)this);
        }
        if (this.group != null) {
            this.group.setActive(this);
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        graphics.blitSprite(this.getSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.renderBg(graphics, mc, mouseX, mouseY);
        BasePregenScreen.drawScrollingShadowString(graphics, mc.font, this.getMessage(), this.getX() + 2, this.getY(), this.width - 4, this.height - 2, Align.CENTER, this.getFGColor(), this.hash);
    }

    public GuiSpriteManager getSpriteManager() {
        return Minecraft.getInstance().getGuiSprites();
    }

    protected ResourceLocation getSprite() {
        return SPRITES.get(this.active, this.isHoveredOrFocused());
    }

    protected int getYOffset() {
        return !this.active ? 0 : (this.isHovered() ? 2 : 1);
    }

    protected void renderBg(GuiGraphics graphics, Minecraft mc, int mouseX, int mouseY) {
    }

    @Override
    public void provideTooltips(Consumer<Component> tooltips) {
        if (this.tooltip != null && this.isHovered()) {
            Component result = this.tooltip.apply(this);
            if (result == null) {
                return;
            }
            tooltips.accept(result);
            this.isHovered = false;
        }
    }
}

