/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class DynamicPregenList<E extends DynamicEntry<E>>
extends ContainerObjectSelectionList<E> {
    int endY;
    protected boolean scrolling;
    protected boolean renderSelection = true;
    protected E hovered;

    public DynamicPregenList(Minecraft minecraft, int width, int height, int startY, int endY, int itemHeight) {
        super(minecraft, width, height, startY, itemHeight);
        this.endY = endY;
    }

    protected E getEntryAtPos(double mouseX, double mouseY) {
        int index;
        int height;
        int centerWidth = this.getRowWidth() / 2;
        int centerX = this.getX() + this.width / 2;
        int minX = centerX - centerWidth;
        int maxX = centerX + centerWidth;
        int position = Mth.floor((double)(mouseY - (double)this.getY())) - this.headerHeight + (int)this.getScrollAmount() - 4;
        for (index = 0; index < this.children().size() && (height = ((DynamicEntry)((Object)this.children().get(index))).getItemHeight()) <= position; position -= height, ++index) {
        }
        return (E)((Object)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && index >= 0 && position >= 0 && index < this.getItemCount() ? (DynamicEntry)((Object)this.children().get(index)) : null));
    }

    protected int getMaxPosition() {
        int max = 0;
        int m = this.getItemCount();
        for (int i = 0; i < m; ++i) {
            max += ((DynamicEntry)((Object)this.children().get(i))).getItemHeight();
        }
        return max;
    }

    protected void scroll(int value) {
        this.setScrollAmount(this.getScrollAmount() + (double)value);
    }

    protected void centerScrollOn(E element) {
        int index = this.children().indexOf(element);
        if (index <= 0) {
            this.setScrollAmount(0.0);
            return;
        }
        int value = 0;
        for (int i = 0; i < index; ++i) {
            value += ((DynamicEntry)((Object)this.children().get(i))).getItemHeight();
        }
        this.setScrollAmount((value += ((DynamicEntry)((Object)this.children().get(index))).getItemHeight() / 2) - (this.getBottom() - this.getY()) / 2);
    }

    protected void ensureVisible(E element) {
        int k;
        int index = this.children().indexOf(element);
        int minY = this.getRowTop(index);
        int itemHeight = index < 0 ? this.itemHeight : ((DynamicEntry)((Object)this.children().get(index))).getItemHeight();
        int maxY = minY - this.getY() - 4 - itemHeight;
        if (maxY < 0) {
            this.scroll(maxY);
        }
        if ((k = this.getBottom() - minY - itemHeight - itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    protected int getRowTop(int p_93512_) {
        int max = this.getY() + 4 - (int)this.getScrollAmount();
        int m = this.getItemCount();
        for (int i = 0; i < m; ++i) {
            max += ((DynamicEntry)((Object)this.children().get(i))).getItemHeight();
        }
        return max + this.headerHeight;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        super.updateScrollingState(mouseX, mouseY, button);
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        E element = this.getEntryAtPos(mouseX, mouseY);
        if (element != null) {
            if (element.mouseClicked(mouseX, mouseY, button)) {
                this.setFocused((GuiEventListener)element);
                this.setDragging(true);
                return true;
            }
        } else if (button == 0) {
            this.clickedHeader((int)(mouseX - (double)(this.getX() + this.width / 2 - this.getRowWidth() / 2)), (int)(mouseY - (double)this.getY()) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean mouseReleased(double p_93491_, double p_93492_, int p_93493_) {
        this.scrolling = false;
        return super.mouseReleased(p_93491_, p_93492_, p_93493_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xScroll, double yScroll) {
        this.scrolling = false;
        this.setScrollAmount(this.getScrollAmount() - yScroll * (double)this.itemHeight * 2.0);
        return true;
    }

    public boolean isScrolling() {
        return this.scrolling;
    }

    protected E getHovered() {
        return this.hovered;
    }

    protected void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float particalTicks) {
        this.hovered = this.isMouseOver(mouseX, mouseY) ? this.getEntryAtPos(mouseX, mouseY) : null;
        int minX = this.getRowLeft();
        int width = this.getRowWidth();
        int size = this.getItemCount();
        int yOff = this.getY() + 4 - (int)this.getScrollAmount() + this.headerHeight;
        int yOffset = 0;
        boolean hasRendered = false;
        for (int i = 0; i < size; ++i) {
            int minY = yOffset + yOff;
            DynamicEntry entry = (DynamicEntry)this.getEntry(i);
            int height = entry.getItemHeight();
            int maxY = minY + height;
            if (maxY >= this.getY() && minY <= this.getBottom()) {
                hasRendered = true;
                this.renderItem(graphics, mouseX, mouseY, particalTicks, i, minX, minY, width, height - 4);
            } else if (hasRendered) break;
            yOffset += height;
        }
    }

    protected void renderDecorations(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.setColor(0.25f, 0.25f, 0.25f, 1.0f);
        Screen.renderMenuBackgroundTexture((GuiGraphics)graphics, (ResourceLocation)Screen.MENU_BACKGROUND, (int)this.getX(), (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.getY());
        Screen.renderMenuBackgroundTexture((GuiGraphics)graphics, (ResourceLocation)Screen.MENU_BACKGROUND, (int)this.getX(), (int)this.getBottom(), (float)0.0f, (float)this.getBottom(), (int)this.width, (int)this.endY);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderItem(GuiGraphics graphics, int mouseX, int mouseY, float particalTicks, int index, int left, int top, int width, int height) {
        DynamicEntry e = (DynamicEntry)this.getEntry(index);
        if (this.renderSelection && this.isSelectedItem(index)) {
            int color = this.isFocused() ? -1 : -8355712;
            this.renderSelection(graphics, left, top, width, height, color, -16777216);
        }
        e.render(graphics, index, top, left, width, height, mouseX, mouseY, Objects.equals(this.getHovered(), (Object)e), particalTicks);
    }

    protected void renderSelection(GuiGraphics graphics, int left, int top, int width, int height, int frameColor, int backgroundColor) {
        graphics.fill(left, top - 2, left + width, top + height + 2, frameColor);
        graphics.fill(left + 1, top - 1, left + width - 1, top + height + 1, backgroundColor);
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        if (this.isFocused()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hovered != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    protected void replaceEntries(Collection<E> elements) {
        elements.forEach(this::bindToSelf);
        super.replaceEntries(elements);
    }

    protected void addEntries(List<E> elements) {
        elements.forEach(this::addEntry);
    }

    protected void addEntries(int index, List<E> elements) {
        elements.forEach(this::bindToSelf);
        this.children().addAll(index, elements);
    }

    protected void addEntry(int index, E element) {
        this.bindToSelf(element);
        this.children().add(index, element);
    }

    protected int addEntry(E element) {
        this.bindToSelf(element);
        return super.addEntry(element);
    }

    protected void addEntryToTop(E element) {
        this.bindToSelf(element);
        super.addEntryToTop(element);
    }

    protected void bindToSelf(E element) {
        ((DynamicEntry)((Object)element)).itemheight = this.itemHeight;
        ((DynamicEntry)((Object)element)).owner = this;
    }

    public static abstract class DynamicEntry<E extends DynamicEntry<E>>
    extends ContainerObjectSelectionList.Entry<E> {
        int itemheight;
        DynamicPregenList<E> owner;
        protected Font font;

        public DynamicEntry() {
            this.font = Minecraft.getInstance().font;
        }

        protected boolean isVisible(int mouseX, int mouseY) {
            return this.owner.getY() <= mouseY && this.owner.getBottom() >= mouseY;
        }

        public int getItemHeight() {
            return this.itemheight;
        }

        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
        }
    }
}

