/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;

public class SelectorScreen<T>
extends BasePregenScreen {
    Screen parent;
    Consumer<T> result;
    List<T> ids;
    T current;
    Function<T, Component> displayFunction;
    SelectionList selections;
    long tick = 0L;

    public SelectorScreen(Screen parent, List<T> ids, T current, Function<T, Component> displayFunction, Consumer<T> result) {
        super((Component)TextUtil.guiConstructor());
        this.parent = parent;
        this.ids = ids;
        this.current = current;
        this.displayFunction = displayFunction;
        this.result = result;
    }

    @Override
    protected void init() {
        super.init();
        this.selections = new SelectionList();
        for (T id : this.ids) {
            this.selections.add(new SelectionEntry(id, this.displayFunction.apply(id)));
        }
        this.selections.select(this.current);
        this.addRenderableWidget((GuiEventListener)this.selections);
        this.button(-86, -30, 80, 20, Align.CENTER, Align.END, (Component)TextUtil.translate("gui.chunk_pregen.selector_screen.pick"), this::pick);
        this.button(5, -30, 80, 20, Align.CENTER, Align.END, (Component)TextUtil.translate("gui.chunk_pregen.selector_screen.cancel"), T -> this.onClose());
    }

    private void pick(Button button) {
        SelectionEntry entry = (SelectionEntry)this.selections.getSelected();
        this.result.accept(entry == null ? null : (Object)entry.id);
        this.minecraft.setScreen(this.parent);
    }

    @Override
    public void tick() {
        super.tick();
        ++this.tick;
    }

    public void onClose() {
        this.result.accept(null);
        this.minecraft.setScreen(this.parent);
    }

    private class SelectionList
    extends ObjectSelectionList<SelectionEntry> {
        int bottomY;

        public SelectionList() {
            super(SelectorScreen.this.minecraft, SelectorScreen.this.width, SelectorScreen.this.height - 86, 50, 24);
            this.bottomY = SelectorScreen.this.height;
        }

        public void add(SelectionEntry entry) {
            this.addEntry((AbstractSelectionList.Entry)entry);
        }

        public void select(T id) {
            for (SelectionEntry entry : this.children()) {
                if (!entry.id.equals(id)) continue;
                this.setSelected((AbstractSelectionList.Entry)entry);
                return;
            }
            this.setSelected(null);
        }

        protected void renderDecorations(GuiGraphics graphics, int mouseX, int mouseY) {
            graphics.setColor(0.25f, 0.25f, 0.25f, 1.0f);
            Screen.renderMenuBackgroundTexture((GuiGraphics)graphics, (ResourceLocation)Screen.MENU_BACKGROUND, (int)this.getX(), (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.getY());
            Screen.renderMenuBackgroundTexture((GuiGraphics)graphics, (ResourceLocation)Screen.MENU_BACKGROUND, (int)this.getX(), (int)this.getBottom(), (float)0.0f, (float)this.getBottom(), (int)this.width, (int)this.bottomY);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public class SelectionEntry
    extends ObjectSelectionList.Entry<SelectionEntry> {
        T id;
        Component name;
        long lastClick = -1L;

        public SelectionEntry(T id, Component name) {
            this.id = id;
            this.name = name;
        }

        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            graphics.drawString(SelectorScreen.this.font, this.name, left, top + height / 2 - 5, SelectorScreen.this.selections.getSelected() == this ? -4472270 : -1);
        }

        public Component getNarration() {
            return this.name;
        }

        public boolean mouseClicked(double p_94737_, double p_94738_, int p_94739_) {
            if (SelectorScreen.this.selections.getSelected() == this) {
                if (this.lastClick >= 0L && SelectorScreen.this.tick - this.lastClick <= 5L) {
                    SelectorScreen.this.pick(null);
                    return true;
                }
                this.lastClick = SelectorScreen.this.tick;
            } else {
                this.lastClick = SelectorScreen.this.tick;
            }
            SelectorScreen.this.selections.select(this.id);
            SelectorScreen.this.current = this.id;
            return true;
        }
    }
}

