/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.dedicated.Settings;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pregenerator.PregenConfig;
import pregenerator.base.mixins.common.server.DedicatedServerMixin;
import pregenerator.base.mixins.common.server.ServerPropertiesMixin;
import pregenerator.client.ClientHandler;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.common.commands.PregenCommand;
import pregenerator.common.commands.arguments.CenterArgument;
import pregenerator.common.commands.arguments.RadiusArgument;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.DimensionManager;
import pregenerator.common.manager.SeedManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.SyncStatePacket;
import pregenerator.common.structures.StructureManager;
import pregenerator.common.tracker.ServerTracker;
import pregenerator.common.utils.config.internal.PermissionRule;
import pregenerator.common.utils.misc.PregenAction;
import pregenerator.common.utils.plugins.PluginLoader;

@Mod(value="chunkpregen")
public class ChunkPregenerator {
    public static ChunkPregenerator INSTANCE;
    public static Logger LOGGER;
    public static final ExecutorService CHUNK_PROCESS_QUEUE;
    public static final String DOCKER_WARNING = "It was detected that the JVM can only see a single Core on this Server. This can have serious Performance implications.\nIf you are running this server in a Docker Container please make sure you enable multithreading in it.\nWhich you can by setting the \"--cpuset-cpus=0,1,2\" argument in your Docker Container. Each Number defines which core specific core should be used, though \"--cpuset-cpus=0-3\" can be used for ranges.\nMore info can be found here: https://docs.docker.com/config/containers/resource_constraints/#configure-the-default-cfs-scheduler";
    public static final PluginLoader PLUGINS;

    public ChunkPregenerator(IEventBus bus) {
        INSTANCE = this;
        bus.register((Object)this);
        PregenConfig.INSTANCE.init();
        NeoForge.EVENT_BUS.register((Object)StructureManager.INSTANCE);
        NeoForge.EVENT_BUS.addListener(this::onServerStart);
        NeoForge.EVENT_BUS.addListener(this::onCommandLoad);
        NeoForge.EVENT_BUS.addListener(DimensionManager.INSTANCE::onServerStarting);
        NeoForge.EVENT_BUS.addListener(SeedManager.INSTANCE::onServerStopping);
        ITask.init();
        IDeletionTask.init();
        IProcessorInfo.init();
        bus.addListener(EventPriority.HIGH, NetworkManager.INSTANCE::init);
        ServerTracker.INSTANCE.init();
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.register((Object)ClientHandler.INSTANCE);
            ClientHandler.INSTANCE.addFunctions(bus);
            NeoForge.EVENT_BUS.addListener(this::onPlayerServerJoinEvent);
        }
    }

    public static List<PregenAction> getValidActions(Player player) {
        if (player.hasPermissions(4)) {
            return ObjectArrayList.wrap((Object[])PregenAction.values());
        }
        PermissionRule rule = (PermissionRule)PregenConfig.INSTANCE.permissionRules.get((Object)player.getUUID());
        return rule == null ? ObjectLists.emptyList() : new ObjectArrayList(rule.getActions());
    }

    public static boolean canDoAction(Player player, PregenAction action) {
        if (player.hasPermissions(4)) {
            return true;
        }
        PermissionRule rule = (PermissionRule)PregenConfig.INSTANCE.permissionRules.get((Object)player.getUUID());
        return rule != null && rule.hasAction(action);
    }

    @SubscribeEvent
    public void onLoaded(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.COMMAND_ARGUMENT_TYPE) && (FMLEnvironment.dist.isClient() || PregenConfig.INSTANCE.advancedArguments.get())) {
            event.register(Registries.COMMAND_ARGUMENT_TYPE, ResourceLocation.parse((String)"chunkpregen:pregen_coord"), () -> ArgumentTypeInfos.registerByClass(CenterArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(CenterArgument::center)));
            event.register(Registries.COMMAND_ARGUMENT_TYPE, ResourceLocation.parse((String)"chunkpregen:pregen_radius"), () -> ArgumentTypeInfos.registerByClass(RadiusArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(RadiusArgument::integer)));
        }
    }

    @SubscribeEvent
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        ServerManager.INSTANCE.init();
    }

    public void onServerStart(ServerStartingEvent event) {
        DedicatedServerSettings provider;
        if (!PregenConfig.INSTANCE.disableWatchDogOverride.get() && event.getServer().isDedicatedServer() && event.getServer() instanceof DedicatedServer && (provider = ((DedicatedServerMixin)event.getServer()).getSettingsProvider()) != null && provider.getProperties().maxTickTime < 600000L) {
            provider.update(T -> {
                Properties props = Settings.loadFromFile((Path)Paths.get("server.properties", new String[0]));
                props.put("max-tick-time", Long.toString(TimeUnit.MINUTES.toMillis(10L)));
                return new DedicatedServerProperties(props);
            });
            LOGGER.info("Upgraded Server Watchdog time from 1 Minute to 10 Minutes to ensure Heavy ModPacks do not crash due to lag");
        }
        if (event.getServer() instanceof DedicatedServer && Runtime.getRuntime().availableProcessors() <= 1 && PregenConfig.INSTANCE.showDockerWarning.get()) {
            LOGGER.error(DOCKER_WARNING);
        }
        if (PregenConfig.INSTANCE.disableDiskProtection.get()) {
            return;
        }
        if (event.getServer() instanceof DedicatedServer) {
            ((ServerPropertiesMixin)((DedicatedServerMixin)event.getServer()).getSettingsProvider().getProperties()).setSyncChunkWrites(false);
        } else if (event.getServer() instanceof IntegratedServer) {
            this.fixClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void fixClient() {
        Minecraft.getInstance().options.syncWrites = false;
    }

    public void onCommandLoad(RegisterCommandsEvent event) {
        PregenCommand.registerCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), PregenConfig.INSTANCE.advancedArguments.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerServerJoinEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        NetworkManager.INSTANCE.sendToServer(new SyncStatePacket(Dist.CLIENT));
    }

    static {
        LOGGER = LogManager.getLogger((String)"Chunk Pregenerator");
        CHUNK_PROCESS_QUEUE = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        PLUGINS = new PluginLoader();
    }
}

