/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.chatimpressiveanimation;

import java.lang.reflect.Method;

public class GlStateManagerHelper {
    private static final Method ENABLE_BLEND;
    private static final Method DISABLE_BLEND;

    public static void enableBlend() {
        try {
            ENABLE_BLEND.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke _enableBlend", e);
        }
    }

    public static void disableBlend() {
        try {
            DISABLE_BLEND.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke _disableBlend", e);
        }
    }

    static {
        Class<?> GL_STATE_MANAGER_CLASS;
        try {
            GL_STATE_MANAGER_CLASS = Class.forName("com.mojang.blaze3d.opengl.GlStateManager");
        }
        catch (ClassNotFoundException e) {
            try {
                GL_STATE_MANAGER_CLASS = Class.forName("com.mojang.blaze3d.platform.GlStateManager");
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not find GlStateManager class", ex);
            }
        }
        try {
            ENABLE_BLEND = GL_STATE_MANAGER_CLASS.getDeclaredMethod("_enableBlend", new Class[0]);
            DISABLE_BLEND = GL_STATE_MANAGER_CLASS.getDeclaredMethod("_disableBlend", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to initialize GlStateManagerHelper", e);
        }
    }
}

