/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.snyc;

import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.snyc.SyncPacket;
import carbonconfiglib.utils.SyncType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class BulkSyncPacket
implements ICarbonPacket {
    public static final StreamCodec<FriendlyByteBuf, BulkSyncPacket> STREAM_CODEC = CustomPacketPayload.codec(BulkSyncPacket::write, ICarbonPacket.readPacket(BulkSyncPacket::new));
    public static final CustomPacketPayload.Type<BulkSyncPacket> ID = ICarbonPacket.createType("carbonconfig:bulksync");
    List<SyncPacket> packets = new ObjectArrayList();

    public BulkSyncPacket(List<SyncPacket> packets) {
        this.packets = packets;
    }

    public BulkSyncPacket(FriendlyByteBuf buffer) {
        int size = buffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            this.packets.add(new SyncPacket(buffer));
        }
    }

    public static BulkSyncPacket create(Collection<ConfigHandler> toSync, SyncType type, boolean forceSync) {
        ObjectArrayList result = new ObjectArrayList();
        for (ConfigHandler handler : toSync) {
            SyncPacket packet = SyncPacket.create(handler, type, forceSync);
            if (packet == null) continue;
            result.add(packet);
        }
        return result.isEmpty() ? null : new BulkSyncPacket((List<SyncPacket>)result);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.packets.size());
        for (SyncPacket packet : this.packets) {
            packet.write(buffer);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void process(Player player) {
        ReloadMode result = null;
        for (SyncPacket packet : this.packets) {
            result = ReloadMode.or(result, packet.processEntry(player));
        }
        if (result != null) {
            player.sendSystemMessage(result.getMessage());
        }
    }
}

