/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.impl.internal;

import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.ISuggestionRenderer;
import carbonconfiglib.gui.config.ColorElement;
import carbonconfiglib.gui.config.RegistryElement;
import carbonconfiglib.gui.widgets.SuggestionRenderers;
import carbonconfiglib.impl.entries.ColorValue;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class InternalFeatures {
    public static void initMinecraftDataTypes(ConfigHandler handlers) {
        handlers.addParser('C', ColorValue::parse);
        handlers.addTempParser('R');
        handlers.addTempParser('r');
        handlers.addTempParser('K');
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void loadDefaultTypes() {
        ISuggestionRenderer.Registry.register(Item.class, new SuggestionRenderers.ItemEntry());
        ISuggestionRenderer.Registry.register(Block.class, new SuggestionRenderers.ItemEntry());
        ISuggestionRenderer.Registry.register(Fluid.class, new SuggestionRenderers.FluidEntry());
        ISuggestionRenderer.Registry.register(Enchantment.class, new SuggestionRenderers.EnchantmentEntry());
        ISuggestionRenderer.Registry.register(ColorValue.ColorWrapper.class, new SuggestionRenderers.ColorEntry());
        ISuggestionRenderer.Registry.register(MobEffect.class, new SuggestionRenderers.PotionEntry());
        DataType.registerType(Item.class, RegistryElement.createForType(Item.class, "minecraft:air"));
        DataType.registerType(Block.class, RegistryElement.createForType(Block.class, "minecraft:air"));
        DataType.registerType(Fluid.class, RegistryElement.createForType(Fluid.class, "minecraft:empty"));
        DataType.registerType(Enchantment.class, RegistryElement.createForType(Enchantment.class, "minecraft:fortune"));
        DataType.registerType(MobEffect.class, RegistryElement.createForType(MobEffect.class, "minecraft:luck"));
        DataType.registerType(ColorValue.ColorWrapper.class, new DataType(false, "0xFFFFFFFF", ColorElement::new, ColorElement::new, ColorElement::new));
    }
}

