/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.impl.forge.ForgeHelpers;
import carbonconfiglib.gui.impl.forge.ForgeNode;
import carbonconfiglib.impl.PerWorldProxy;
import carbonconfiglib.networking.forge.RequestConfigPacket;
import carbonconfiglib.networking.forge.SaveForgeConfigPacket;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.toml.TomlFormat;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ForgeConfig
implements IModConfig {
    ModConfig config;
    ModConfigSpec spec;
    IConfigSpec.ILoadedConfig loaded;
    CommentedConfig data;
    List<ModConfigSpec.ConfigValue<?>> entries;
    Path path;

    public ForgeConfig(ModConfig config) {
        this.config = config;
        this.spec = (ModConfigSpec)config.getSpec();
        this.loaded = (IConfigSpec.ILoadedConfig)ObfuscationReflectionHelper.getPrivateValue(ModConfig.class, (Object)config, (String)"loadedConfig");
        this.data = this.loaded != null ? this.loaded.config() : null;
        this.entries = this.collect();
    }

    public ForgeConfig(ModConfig config, CommentedConfig data, Path path) {
        this.config = config;
        this.data = data;
        this.path = path;
        this.spec = (ModConfigSpec)config.getSpec();
        this.entries = this.collect();
    }

    @Override
    public boolean canCreateConfigs() {
        return false;
    }

    @Override
    public boolean createConfig(Path path) {
        return false;
    }

    @Override
    public String getFileName() {
        return this.config.getFileName();
    }

    @Override
    public String getConfigName() {
        return this.config.getFileName();
    }

    @Override
    public String getModId() {
        return this.config.getModId();
    }

    @Override
    public boolean isDynamicConfig() {
        return this.config.getType() == ModConfig.Type.SERVER;
    }

    @Override
    public boolean isLocalConfig() {
        return this.path == null;
    }

    @Override
    public ConfigType getConfigType() {
        switch (this.config.getType()) {
            case CLIENT: {
                return ConfigType.CLIENT;
            }
            case COMMON: {
                return ConfigType.SHARED;
            }
            case SERVER: {
                return ConfigType.SERVER;
            }
        }
        throw new IllegalArgumentException("Type: " + String.valueOf(this.config.getType()) + ", not supported");
    }

    @Override
    public IConfigNode getRootNode() {
        return new ForgeNode((List<String>)new ObjectArrayList(), this.data, this.spec);
    }

    @Override
    public boolean isDefault() {
        if (this.data == null) {
            return true;
        }
        int m = this.entries.size();
        for (int i = 0; i < m; ++i) {
            ModConfigSpec.ConfigValue<?> entry = this.entries.get(i);
            if (this.eqauls(entry.getDefault(), this.data.get(entry.getPath()))) continue;
            return false;
        }
        return true;
    }

    private boolean eqauls(Object defaultValue, Object value) {
        if (defaultValue.getClass().isEnum() && value instanceof String) {
            return ((Enum)defaultValue).name().equals(value);
        }
        return Objects.equals(defaultValue, value);
    }

    @Override
    public void restoreDefault() {
        if (this.data == null) {
            return;
        }
        int m = this.entries.size();
        for (int i = 0; i < m; ++i) {
            ModConfigSpec.ConfigValue<?> entry = this.entries.get(i);
            this.data.set(entry.getPath(), entry.getDefault());
        }
    }

    @Override
    public List<IModConfig.IConfigTarget> getPotentialFiles() {
        if (this.getConfigType() == ConfigType.SERVER) {
            return this.getLevels();
        }
        return ObjectLists.emptyList();
    }

    @Override
    public IModConfig loadFromFile(Path path) {
        try {
            return new ForgeConfig(this.config, (CommentedConfig)TomlFormat.instance().createParser().parse(path, FileNotFoundAction.THROW_ERROR), path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IModConfig loadFromNetworking(UUID requestId, Consumer<Predicate<FriendlyByteBuf>> network) {
        NetworkForgeConfig config = new NetworkForgeConfig(this.config);
        CarbonConfig.NETWORK.sendToServer(new RequestConfigPacket(this.config.getType(), requestId, this.config.getModId(), config.getFileName()));
        network.accept(config);
        return config;
    }

    @Override
    public void save() {
        if (this.loaded == null) {
            ForgeHelpers.saveConfig(this.path, this.data);
            return;
        }
        this.loaded.save();
        this.spec.afterReload();
    }

    private List<ModConfigSpec.ConfigValue<?>> collect() {
        ObjectArrayList values = new ObjectArrayList();
        this.iterate(this.spec.getValues().valueMap().values(), ((List)values)::add);
        return values;
    }

    private void iterate(Iterable<Object> source, Consumer<ModConfigSpec.ConfigValue<?>> result) {
        for (Object entry : source) {
            if (entry instanceof ModConfigSpec.ConfigValue) {
                result.accept((ModConfigSpec.ConfigValue)entry);
                continue;
            }
            if (!(entry instanceof Config)) continue;
            this.iterate(((Config)entry).valueMap().values(), result);
        }
    }

    private List<IModConfig.IConfigTarget> getLevels() {
        LevelStorageSource storage = Minecraft.getInstance().getLevelSource();
        ObjectArrayList folders = new ObjectArrayList();
        for (LevelSummary sum : (List)storage.loadLevelSummaries(storage.findLevelCandidates()).join()) {
            try {
                LevelStorageSource.LevelStorageAccess access = Minecraft.getInstance().getLevelSource().createAccess(sum.getLevelId());
                try {
                    Path file;
                    Path path = access.getLevelPath(PerWorldProxy.SERVERCONFIG);
                    if (Files.notExists(path, new LinkOption[0]) || Files.notExists(file = path.resolve(this.config.getFileName()), new LinkOption[0])) continue;
                    folders.add(new IModConfig.WorldConfigTarget(new PerWorldProxy.WorldTarget(sum, access.getLevelPath(LevelResource.ROOT), path), file));
                }
                finally {
                    if (access == null) continue;
                    access.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return folders;
    }

    public static class NetworkForgeConfig
    extends ForgeConfig
    implements Predicate<FriendlyByteBuf> {
        public NetworkForgeConfig(ModConfig config) {
            super(config, null, null);
        }

        @Override
        public boolean test(FriendlyByteBuf t) {
            try {
                this.data = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(t.readByteArray()));
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public void save() {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.data.configFormat().createWriter().write((UnmodifiableConfig)this.data, (OutputStream)stream);
            CarbonConfig.NETWORK.sendToServer(new SaveForgeConfigPacket(this.config.getType(), this.config.getModId(), this.config.getFileName(), stream.toByteArray()));
        }

        @Override
        public boolean isLocalConfig() {
            return false;
        }
    }
}

