/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.api;

import carbonconfiglib.api.buffer.IReadBuffer;
import carbonconfiglib.api.buffer.IWriteBuffer;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.ParsedCollections;
import carbonconfiglib.utils.structure.StructureCompound;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectOpenHashMap;

public interface IConfigSerializer<T> {
    public T getExample();

    public StructureCompound.CompoundData getFormat();

    public ParseResult<Boolean> isValid(T var1);

    public ParseResult<T> deserialize(ParsedCollections.ParsedMap var1);

    public ParsedCollections.ParsedMap serialize(T var1);

    public T deserialize(IReadBuffer var1);

    public void serialize(IWriteBuffer var1, T var2);

    public static <T> IConfigSerializer<T> noSync(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, ParseResult<T>> reader, Function<T, ParsedCollections.ParsedMap> writer) {
        return new FunctionWriter<T>(format, example, reader, writer, null, null, null);
    }

    public static <T> IConfigSerializer<T> noSync(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, ParseResult<T>> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<T, ParseResult<Boolean>> filter) {
        return new FunctionWriter<T>(format, example, reader, writer, filter, null, null);
    }

    public static <T> IConfigSerializer<T> withSync(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, ParseResult<T>> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
        return new FunctionWriter<T>(format, example, reader, writer, null, readBuffer, writeBuffer);
    }

    public static <T> IConfigSerializer<T> withSync(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, ParseResult<T>> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<T, ParseResult<Boolean>> filter, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
        return new FunctionWriter<T>(format, example, reader, writer, filter, readBuffer, writeBuffer);
    }

    public static <T> IConfigSerializer<T> simple(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, T> reader, Function<T, ParsedCollections.ParsedMap> writer) {
        return new SimpleWriter<T>(format, example, reader, writer, null, null, null);
    }

    public static <T> IConfigSerializer<T> simple(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, T> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<T, ParseResult<Boolean>> filter) {
        return new SimpleWriter<T>(format, example, reader, writer, filter, null, null);
    }

    public static <T> IConfigSerializer<T> simpleSync(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, T> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
        return new SimpleWriter<T>(format, example, reader, writer, null, readBuffer, writeBuffer);
    }

    public static <T> IConfigSerializer<T> simpleSync(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, T> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<T, ParseResult<Boolean>> filter, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
        return new SimpleWriter<T>(format, example, reader, writer, filter, readBuffer, writeBuffer);
    }

    public static <T> IConfigSerializer<T> reflectNoSync(StructureCompound.CompoundData format, T example) {
        return new FunctionWriter<T>(format, example, new Parser(example.getClass(), format), new Serializer(example.getClass(), format), null, null, null);
    }

    public static <T> IConfigSerializer<T> reflectNoSync(StructureCompound.CompoundData format, T example, Function<T, ParseResult<Boolean>> filter) {
        return new FunctionWriter<T>(format, example, new Parser(example.getClass(), format), new Serializer(example.getClass(), format), filter, null, null);
    }

    public static <T> IConfigSerializer<T> reflectSync(StructureCompound.CompoundData format, T example, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
        return new FunctionWriter<T>(format, example, new Parser(example.getClass(), format), new Serializer(example.getClass(), format), null, readBuffer, writeBuffer);
    }

    public static <T> IConfigSerializer<T> reflectSync(StructureCompound.CompoundData format, T example, Function<T, ParseResult<Boolean>> filter, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
        return new FunctionWriter<T>(format, example, new Parser(example.getClass(), format), new Serializer(example.getClass(), format), filter, readBuffer, writeBuffer);
    }

    public static class FunctionWriter<T>
    implements IConfigSerializer<T> {
        StructureCompound.CompoundData format;
        T example;
        Function<ParsedCollections.ParsedMap, ParseResult<T>> reader;
        Function<T, ParsedCollections.ParsedMap> writer;
        Function<T, ParseResult<Boolean>> filter;
        Function<IReadBuffer, T> readBuffer;
        BiConsumer<IWriteBuffer, T> writeBuffer;

        public FunctionWriter(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, ParseResult<T>> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<T, ParseResult<Boolean>> filter, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
            this.format = format;
            this.example = example;
            this.reader = reader;
            this.writer = writer;
            this.filter = filter;
            this.readBuffer = readBuffer;
            this.writeBuffer = writeBuffer;
        }

        @Override
        public T getExample() {
            return this.example;
        }

        @Override
        public StructureCompound.CompoundData getFormat() {
            return this.format;
        }

        @Override
        public ParseResult<Boolean> isValid(T value) {
            return this.filter == null ? ParseResult.success(true) : this.filter.apply(value);
        }

        @Override
        public ParseResult<T> deserialize(ParsedCollections.ParsedMap value) {
            ParseResult<Object> preCheck = value.validate(this.format);
            if (preCheck.hasError()) {
                return preCheck.onlyError();
            }
            return this.reader.apply(value);
        }

        @Override
        public ParsedCollections.ParsedMap serialize(T value) {
            return this.writer.apply(value);
        }

        @Override
        public T deserialize(IReadBuffer buffer) {
            if (this.readBuffer == null || this.writeBuffer == null) {
                throw new UnsupportedOperationException("No Read/Write Buffer Provided");
            }
            return this.readBuffer.apply(buffer);
        }

        @Override
        public void serialize(IWriteBuffer buffer, T value) {
            if (this.readBuffer == null || this.writeBuffer == null) {
                throw new UnsupportedOperationException("No Read/Write Buffer Provided");
            }
            this.writeBuffer.accept(buffer, (IWriteBuffer)value);
        }
    }

    public static class SimpleWriter<T>
    implements IConfigSerializer<T> {
        StructureCompound.CompoundData format;
        T example;
        Function<ParsedCollections.ParsedMap, T> reader;
        Function<T, ParsedCollections.ParsedMap> writer;
        Function<T, ParseResult<Boolean>> filter;
        Function<IReadBuffer, T> readBuffer;
        BiConsumer<IWriteBuffer, T> writeBuffer;

        public SimpleWriter(StructureCompound.CompoundData format, T example, Function<ParsedCollections.ParsedMap, T> reader, Function<T, ParsedCollections.ParsedMap> writer, Function<T, ParseResult<Boolean>> filter, Function<IReadBuffer, T> readBuffer, BiConsumer<IWriteBuffer, T> writeBuffer) {
            this.format = format;
            this.example = example;
            this.reader = reader;
            this.writer = writer;
            this.filter = filter;
            this.readBuffer = readBuffer;
            this.writeBuffer = writeBuffer;
        }

        @Override
        public T getExample() {
            return this.example;
        }

        @Override
        public StructureCompound.CompoundData getFormat() {
            return this.format;
        }

        @Override
        public ParseResult<Boolean> isValid(T value) {
            return this.filter == null ? ParseResult.success(true) : this.filter.apply(value);
        }

        @Override
        public ParseResult<T> deserialize(ParsedCollections.ParsedMap value) {
            ParseResult<Object> preCheck = value.validate(this.format);
            if (preCheck.hasError()) {
                return preCheck.onlyError();
            }
            try {
                T result = this.reader.apply(value);
                if (result == null) {
                    return ParseResult.error(NullPointerException::new, "Parsing of [" + String.valueOf(this.example.getClass()) + "] resulted in a null");
                }
                return ParseResult.success(result);
            }
            catch (Exception e) {
                e.printStackTrace();
                return ParseResult.error(value.toString(), e, "Parsing of [" + String.valueOf(this.example.getClass()) + "] Failed");
            }
        }

        @Override
        public ParsedCollections.ParsedMap serialize(T value) {
            return this.writer.apply(value);
        }

        @Override
        public T deserialize(IReadBuffer buffer) {
            if (this.readBuffer == null || this.writeBuffer == null) {
                throw new UnsupportedOperationException("No Read/Write Buffer Provided");
            }
            return this.readBuffer.apply(buffer);
        }

        @Override
        public void serialize(IWriteBuffer buffer, T value) {
            if (this.readBuffer == null || this.writeBuffer == null) {
                throw new UnsupportedOperationException("No Read/Write Buffer Provided");
            }
            this.writeBuffer.accept(buffer, (IWriteBuffer)value);
        }
    }

    public static class Parser<T>
    implements Function<ParsedCollections.ParsedMap, ParseResult<T>> {
        private static final Map<Class<?>, Class<?>> WRAPPERS = Parser.createWrappers();
        Class<T> type;
        StructureCompound.CompoundData data;

        private static Map<Class<?>, Class<?>> createWrappers() {
            Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap();
            result.put(Boolean.TYPE, Boolean.class);
            result.put(Byte.TYPE, Byte.class);
            result.put(Character.TYPE, Character.class);
            result.put(Short.TYPE, Short.class);
            result.put(Integer.TYPE, Integer.class);
            result.put(Long.TYPE, Long.class);
            result.put(Float.TYPE, Float.class);
            result.put(Double.TYPE, Double.class);
            return result;
        }

        public Parser(Class<T> type, StructureCompound.CompoundData data) {
            this.type = type;
            this.data = data;
        }

        @Override
        public ParseResult<T> apply(ParsedCollections.ParsedMap t) {
            try {
                T value = this.type.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (String key : this.data.getKeys()) {
                    try {
                        Field field = this.type.getDeclaredField(key);
                        field.setAccessible(true);
                        Class<?> type = field.getType();
                        boolean collection = Collection.class.isAssignableFrom(type);
                        ParseResult<ParsedCollections.ParsedList> data = t.getOrError(key, collection ? ParsedCollections.ParsedList.class : WRAPPERS.getOrDefault(type, type));
                        if (data.hasError()) {
                            return data.onlyError();
                        }
                        if (collection) {
                            field.set(value, this.unwrap(data.getValue()));
                            continue;
                        }
                        field.set(value, data.getValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return ParseResult.error(t.toString(), e, "Couldn't Set Field [" + key + "] in class [" + this.type.getSimpleName() + "]");
                    }
                }
                return ParseResult.success(value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return ParseResult.error(t.toString(), e, "Couldn't create instance of [" + this.type.getSimpleName() + "]");
            }
        }

        private <S> List<S> unwrap(ParsedCollections.ParsedList list) {
            ObjectArrayList result = new ObjectArrayList();
            for (Object entry : list.objectIterator()) {
                if (entry instanceof ParsedCollections.ParsedList) {
                    result.add(this.unwrap((ParsedCollections.ParsedList)entry));
                    continue;
                }
                result.add(entry);
            }
            return result;
        }
    }

    public static class Serializer<T>
    implements Function<T, ParsedCollections.ParsedMap> {
        Class<T> type;
        StructureCompound.CompoundData data;

        public Serializer(Class<T> type, StructureCompound.CompoundData data) {
            this.type = type;
            this.data = data;
        }

        @Override
        public ParsedCollections.ParsedMap apply(T t) {
            ParsedCollections.ParsedMap map = new ParsedCollections.ParsedMap();
            try {
                for (String key : this.data.getKeys()) {
                    Field field = this.type.getDeclaredField(key);
                    field.setAccessible(true);
                    Object data = field.get(t);
                    if (data instanceof Collection) {
                        map.put(key, this.wrapList((Collection)data));
                        continue;
                    }
                    map.put(key, data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return map;
        }

        private ParsedCollections.ParsedList wrapList(Collection<? extends Object> data) {
            ParsedCollections.ParsedList list = new ParsedCollections.ParsedList();
            for (Object object : data) {
                if (object instanceof Collection) {
                    list.add(this.wrapList((Collection)object));
                    continue;
                }
                list.add(object);
            }
            return list;
        }
    }
}

