/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import team.chisel.ctm.api.texture.ISubmap;

public class Submap
implements ISubmap {
    public static final ISubmap X1 = Submap.fromPixelScale(16.0f, 16.0f, 0.0f, 0.0f);
    public static final ISubmap[][] X2 = new ISubmap[][]{{Submap.fromPixelScale(8.0f, 8.0f, 0.0f, 0.0f), Submap.fromPixelScale(8.0f, 8.0f, 8.0f, 0.0f)}, {Submap.fromPixelScale(8.0f, 8.0f, 0.0f, 8.0f), Submap.fromPixelScale(8.0f, 8.0f, 8.0f, 8.0f)}};
    private static final float DIV3 = 5.3333335f;
    public static final ISubmap[][] X3 = new ISubmap[][]{{Submap.fromPixelScale(5.3333335f, 5.3333335f, 0.0f, 0.0f), Submap.fromPixelScale(5.3333335f, 5.3333335f, 5.3333335f, 0.0f), Submap.fromPixelScale(5.3333335f, 5.3333335f, 10.666667f, 0.0f)}, {Submap.fromPixelScale(5.3333335f, 5.3333335f, 0.0f, 5.3333335f), Submap.fromPixelScale(5.3333335f, 5.3333335f, 5.3333335f, 5.3333335f), Submap.fromPixelScale(5.3333335f, 5.3333335f, 10.666667f, 5.3333335f)}, {Submap.fromPixelScale(5.3333335f, 5.3333335f, 0.0f, 10.666667f), Submap.fromPixelScale(5.3333335f, 5.3333335f, 5.3333335f, 10.666667f), Submap.fromPixelScale(5.3333335f, 5.3333335f, 10.666667f, 10.666667f)}};
    public static final ISubmap[][] X4 = new ISubmap[][]{{Submap.fromPixelScale(4.0f, 4.0f, 0.0f, 0.0f), Submap.fromPixelScale(4.0f, 4.0f, 4.0f, 0.0f), Submap.fromPixelScale(4.0f, 4.0f, 8.0f, 0.0f), Submap.fromPixelScale(4.0f, 4.0f, 12.0f, 0.0f)}, {Submap.fromPixelScale(4.0f, 4.0f, 0.0f, 4.0f), Submap.fromPixelScale(4.0f, 4.0f, 4.0f, 4.0f), Submap.fromPixelScale(4.0f, 4.0f, 8.0f, 4.0f), Submap.fromPixelScale(4.0f, 4.0f, 12.0f, 4.0f)}, {Submap.fromPixelScale(4.0f, 4.0f, 0.0f, 8.0f), Submap.fromPixelScale(4.0f, 4.0f, 4.0f, 8.0f), Submap.fromPixelScale(4.0f, 4.0f, 8.0f, 8.0f), Submap.fromPixelScale(4.0f, 4.0f, 12.0f, 8.0f)}, {Submap.fromPixelScale(4.0f, 4.0f, 0.0f, 12.0f), Submap.fromPixelScale(4.0f, 4.0f, 4.0f, 12.0f), Submap.fromPixelScale(4.0f, 4.0f, 8.0f, 12.0f), Submap.fromPixelScale(4.0f, 4.0f, 12.0f, 12.0f)}};
    private final float width;
    private final float height;
    private final float xOffset;
    private final float yOffset;
    final ISubmap.SubmapRescaled rescaled;

    public static ISubmap[][] grid(int w, int h) {
        float xDiv = 16.0f / (float)w;
        float yDiv = 16.0f / (float)h;
        ISubmap[][] ret = new ISubmap[h][w];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                ret[y][x] = Submap.fromPixelScale(xDiv, yDiv, xDiv * (float)x, yDiv * (float)y);
            }
        }
        return ret;
    }

    public static ISubmap raw(float width, float height, float xOffset, float yOffset) {
        return new Submap(width, height, xOffset, yOffset, 1.0f);
    }

    public static ISubmap fromUnitScale(float width, float height, float xOffset, float yOffset) {
        return Submap.fromPixelScale(width * 16.0f, height * 16.0f, xOffset * 16.0f, yOffset * 16.0f);
    }

    public static ISubmap fromPixelScale(float width, float height, float xOffset, float yOffset) {
        return new Submap(width, height, xOffset, yOffset, 0.0625f);
    }

    private Submap(float width, float height, float xOffset, float yOffset, float rescale) {
        this.width = width;
        this.height = height;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.rescaled = new ISubmap.SubmapRescaled(this, rescale, false);
    }

    @Override
    public ISubmap.SubmapRescaled pixelScale() {
        return this.rescaled;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getXOffset() {
        return this.xOffset;
    }

    @Override
    public float getYOffset() {
        return this.yOffset;
    }

    public ISubmap.SubmapRescaled getRescaled() {
        return this.rescaled;
    }

    public String toString() {
        return "Submap(width=" + this.getWidth() + ", height=" + this.getHeight() + ", xOffset=" + this.getXOffset() + ", yOffset=" + this.getYOffset() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Submap)) {
            return false;
        }
        Submap other = (Submap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (Float.compare(this.getHeight(), other.getHeight()) != 0) {
            return false;
        }
        if (Float.compare(this.getXOffset(), other.getXOffset()) != 0) {
            return false;
        }
        return Float.compare(this.getYOffset(), other.getYOffset()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Submap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + Float.floatToIntBits(this.getHeight());
        result = result * 59 + Float.floatToIntBits(this.getXOffset());
        result = result * 59 + Float.floatToIntBits(this.getYOffset());
        return result;
    }
}

