/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.newctm;

import com.google.common.annotations.VisibleForTesting;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.client.newctm.CTMLogicBakery;
import team.chisel.ctm.client.newctm.ConnectionCheck;
import team.chisel.ctm.client.newctm.ICTMLogic;
import team.chisel.ctm.client.newctm.ILogicCache;
import team.chisel.ctm.client.newctm.LocalDirection;

public class CustomCTMLogic
implements ICTMLogic {
    @VisibleForTesting
    public final int[][] lookups;
    private final CTMLogicBakery.OutputFace[] tiles;
    private final LocalDirection[] directions;
    private final ConnectionCheck connectionCheck = new ConnectionCheck();
    private List<ISubmap> outputSubmapCache;
    private int textureCountCache = -1;

    @Override
    public int[] getSubmapIds(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side) {
        return this.getSubmapIds(world, pos, state, side, this.connectionCheck);
    }

    private int[] getSubmapIds(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side, ConnectionCheck connectionCheck) {
        int key = 0;
        for (int i = 0; i < this.directions.length; ++i) {
            boolean isConnected = this.directions[i].isConnected(connectionCheck, world, pos, state, side);
            key |= (isConnected ? 1 : 0) << i;
        }
        if (key >= this.lookups.length || this.lookups[key] == null) {
            throw new IllegalStateException("Input state found that is not in lookup table: " + Integer.toBinaryString(key));
        }
        return this.lookups[key];
    }

    @Override
    public CTMLogicBakery.OutputFace[] getSubmaps(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side) {
        int[] tileIds = this.getSubmapIds(world, pos, state, side);
        return this.getSubmaps(tileIds);
    }

    private CTMLogicBakery.OutputFace[] getSubmaps(int[] tileIds) {
        CTMLogicBakery.OutputFace[] ret = new CTMLogicBakery.OutputFace[tileIds.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.tiles[tileIds[i]];
        }
        return ret;
    }

    @Override
    public ILogicCache cached(@Nullable ConnectionCheck connectionCheck) {
        return new Cache(connectionCheck);
    }

    @Override
    public List<ISubmap> outputSubmaps() {
        if (this.outputSubmapCache == null) {
            HashSet<ISubmap> seen = new HashSet<ISubmap>();
            for (CTMLogicBakery.OutputFace tile : this.tiles) {
                seen.add(tile.face());
            }
            this.outputSubmapCache = List.copyOf(seen);
        }
        return this.outputSubmapCache;
    }

    @Override
    public ISubmap getFallbackUvs() {
        return this.tiles.length == 0 ? ICTMLogic.super.getFallbackUvs() : this.tiles[0].uvs();
    }

    @Override
    public int requiredTextures() {
        if (this.textureCountCache < 0) {
            BitSet seen = new BitSet();
            for (CTMLogicBakery.OutputFace tile : this.tiles) {
                seen.set(tile.tex());
            }
            this.textureCountCache = seen.cardinality();
        }
        return this.textureCountCache;
    }

    public CustomCTMLogic(int[][] lookups, CTMLogicBakery.OutputFace[] tiles, LocalDirection[] directions) {
        this.lookups = lookups;
        this.tiles = tiles;
        this.directions = directions;
    }

    private class Cache
    implements ILogicCache {
        @Nullable
        private final ConnectionCheck connectionCheckOverride;
        private int[] cachedSubmapIds;
        private CTMLogicBakery.OutputFace[] cachedSubmaps;

        public Cache(ConnectionCheck connectionCheck) {
            this.connectionCheckOverride = connectionCheck;
        }

        @Override
        public CTMLogicBakery.OutputFace[] getCachedSubmaps() {
            return this.cachedSubmaps;
        }

        @Override
        public long serialized() {
            int len = this.cachedSubmapIds.length;
            int stride = CustomCTMLogic.this.directions.length;
            if (len * stride > 64) {
                throw new IllegalStateException("Too many submaps to serialize");
            }
            long ret = 0L;
            for (int i = 0; i < this.cachedSubmapIds.length; ++i) {
                ret |= (long)this.cachedSubmapIds[i] << i * stride;
            }
            return ret;
        }

        @Override
        public void buildConnectionMap(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side) {
            this.cachedSubmapIds = CustomCTMLogic.this.getSubmapIds(world, pos, state, side, this.connectionCheckOverride);
            this.cachedSubmaps = CustomCTMLogic.this.getSubmaps(this.cachedSubmapIds);
        }
    }
}

