/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.item.custom;

import com.cerbon.bosses_of_mass_destruction.entity.BMDEntities;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichUtils;
import com.cerbon.bosses_of_mass_destruction.item.BMDItems;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.cerbons_api.api.general.event.Event;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.particle.ClientParticleBuilder;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SoulStarEntity
extends Entity
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(SoulStarEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final ClientParticleBuilder particleBuilder = new ClientParticleBuilder((ParticleOptions)BMDParticles.SPARKLES.get()).color(LichUtils.blueColorFade).age(RandomUtils.range((int)80, (int)100)).colorVariation(0.3).scale(f -> Float.valueOf(0.05f - f.floatValue() * 0.025f)).brightness(0xF000F0);
    private double targetX = 0.0;
    private double targetY = 0.0;
    private double targetZ = 0.0;

    public SoulStarEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public SoulStarEntity(Level level, double x, double y, double z) {
        this((EntityType)BMDEntities.SOUL_STAR.get(), level);
        this.absMoveTo(x, y, z);
    }

    public void setItem(ItemStack stack) {
        if (stack.isEmpty()) {
            this.getEntityData().set(ITEM, (Object)new ItemStack((ItemLike)BMDItems.SOUL_STAR.get()));
        } else {
            this.getEntityData().set(ITEM, (Object)stack.copyWithCount(1));
        }
    }

    private ItemStack getTrackedItem() {
        return (ItemStack)this.getEntityData().get(ITEM);
    }

    @NotNull
    public ItemStack getItem() {
        ItemStack itemStack = this.getTrackedItem();
        return itemStack.isEmpty() ? new ItemStack((ItemLike)BMDItems.SOUL_STAR.get()) : itemStack;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEM, (Object)ItemStack.EMPTY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d)) {
            d = 4.0;
        }
        return distance < (d *= 64.0) * d;
    }

    public void initTargetPos(BlockPos pos) {
        double d = pos.getX();
        double e = pos.getZ();
        double f = d - this.getX();
        double g = e - this.getZ();
        double h = Math.sqrt(f * f + g * g);
        this.targetX = this.getX() + f / h * 12.0;
        this.targetZ = this.getZ() + g / h * 12.0;
        this.targetY = this.getY() + 8.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double f = Math.sqrt(x * x + z * z);
            this.setYRot((float)(Mth.atan2((double)x, (double)z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)y, (double)f) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
    }

    public void tick() {
        if (this.level().isClientSide() && this.tickCount == 1) {
            double rotationOffset = this.random.nextDouble() * 360.0;
            CapabilityUtils.getLevelEventScheduler((Level)this.level()).addEvent((IEvent)new Event(() -> true, () -> this.spawnTrailParticles(rotationOffset), () -> ((SoulStarEntity)this).isRemoved()));
        }
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        double d = this.getX() + vec3.x;
        double e = this.getY() + vec3.y;
        double f = this.getZ() + vec3.z;
        double g = vec3.horizontalDistance();
        this.setXRot(this.updateRotation(this.xRotO, (float)(Mth.atan2((double)vec3.y, (double)g) * 57.2957763671875)));
        this.setYRot(this.updateRotation(this.yRotO, (float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875)));
        if (!this.level().isClientSide()) {
            double xd = this.targetX - d;
            double zd = this.targetZ - f;
            float distance = (float)Math.sqrt(xd * xd + zd * zd);
            float k = (float)Mth.atan2((double)zd, (double)xd);
            double l = Mth.lerp((double)0.0025, (double)g, (double)distance);
            double m = vec3.y;
            if (distance < 1.0f) {
                l *= 0.8;
                m *= 0.8;
                this.playSound((SoundEvent)BMDSounds.SOUL_STAR.get(), 1.0f, 1.0f);
                this.discard();
                this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem()));
            }
            int n = this.getY() < this.targetY ? 1 : -1;
            vec3 = new Vec3(Math.cos(k) * l, m + ((double)n - m) * (double)0.015f, Math.sin(k) * l);
            this.setDeltaMovement(vec3);
            this.absMoveTo(d, e, f);
        } else {
            this.setPosRaw(d, e, f);
        }
        this.spawnParticles(d, vec3, e, f);
    }

    private void spawnTrailParticles(double rotationOffset) {
        Vec3 look = this.getDeltaMovement();
        Vec3 cross = look.cross(VecUtils.yAxis).normalize();
        Vec3 rotatedOffset = VecUtils.rotateVector((Vec3)cross, (Vec3)look, (double)(rotationOffset + (double)this.tickCount * 30.0)).scale(0.25);
        Vec3 particlePos = this.position().add(rotatedOffset);
        this.particleBuilder.build(particlePos, this.getDeltaMovement().scale(0.1));
    }

    private void spawnParticles(double d, Vec3 vec3, double e, double f) {
        if (this.isInWater()) {
            for (int p = 0; p <= 3; ++p) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d - vec3.x * 0.25, e - vec3.y * 0.25, f - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        ItemStack itemStack = this.getTrackedItem();
        if (!itemStack.isEmpty()) {
            compound.put("Item", itemStack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag()));
        }
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)compound.getCompound("Item"));
        this.setItem(itemStack);
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public boolean isAttackable() {
        return false;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return super.getAddEntityPacket(entity);
    }

    private float updateRotation(float f, float g) {
        float f1 = f;
        while (g - f1 < -180.0f) {
            f1 -= 360.0f;
        }
        while (g - f1 >= 180.0f) {
            f1 += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)f1, (float)g);
    }
}

