/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom;

import com.cerbon.bosses_of_mass_destruction.entity.util.IEntityTick;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class LightBlockRemover
implements IEntityTick<ServerLevel> {
    private final LivingEntity entity;
    public static final float deathMaxAge = 70.0f;

    public LightBlockRemover(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public void tick(ServerLevel level) {
        ++this.entity.deathTime;
        float interceptedTime = MathUtils.ratioLerp((float)this.entity.deathTime, (float)0.5f, (float)70.0f, (float)0.0f) * 0.7f;
        level.setBlockAndUpdate(this.entity.blockPosition(), (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(Math.round((1.0f - interceptedTime) * 15.0f))));
        if (this.entity.deathTime == 49) {
            SoundUtils.playSound((ServerLevel)level, (Vec3)this.entity.position(), (SoundEvent)((SoundEvent)BMDSounds.VOID_BLOSSOM_FALL.get()), (SoundSource)SoundSource.HOSTILE, (float)1.5f, (double)32.0, null);
        }
        if ((float)this.entity.deathTime == 70.0f) {
            if (level.getBlockState(this.entity.blockPosition()).getBlock() == Blocks.LIGHT) {
                level.setBlockAndUpdate(this.entity.blockPosition(), Blocks.AIR.defaultBlockState());
            }
            level.broadcastEntityEvent((Entity)this.entity, (byte)60);
            this.entity.remove(Entity.RemovalReason.KILLED);
        }
    }
}

