/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith;

import com.cerbon.bosses_of_mass_destruction.entity.damage.IDamageHandler;
import com.cerbon.bosses_of_mass_destruction.entity.util.IEntityStats;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ShieldDamageHandler
implements IDamageHandler {
    private final Supplier<Boolean> isShielded;

    public ShieldDamageHandler(Supplier<Boolean> isShielded) {
        this.isShielded = isShielded;
    }

    @Override
    public void beforeDamage(IEntityStats stats, DamageSource damageSource, float amount) {
    }

    @Override
    public void afterDamage(IEntityStats stats, DamageSource damageSource, float amount, boolean result) {
    }

    @Override
    public boolean shouldDamage(LivingEntity actor, DamageSource damageSource, float amount) {
        if (this.isShielded.get().booleanValue() && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            Entity entity;
            if (!damageSource.is(DamageTypeTags.IS_PROJECTILE) && (entity = damageSource.getEntity()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.knockback(0.5, actor.getX() - livingEntity.getX(), actor.getZ() - livingEntity.getZ());
            }
            actor.playSound((SoundEvent)BMDSounds.ENERGY_SHIELD.get(), 1.0f, SoundUtils.randomPitch((RandomSource)actor.getRandom()));
            return false;
        }
        return true;
    }
}

