/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.entity.ai.action.IActionWithCooldown;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.bosses_of_mass_destruction.util.BMDUtils;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.MobUtils;
import com.cerbon.cerbons_api.api.static_utilities.ParticleUtils;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class PillarAction
implements IActionWithCooldown {
    private final LivingEntity entity;
    private final EventScheduler eventScheduler;
    public static final double pillarXzDistance = 13.0;
    public static final double maxYDistance = 15.0;
    public static final int pillarDelay = 40;

    public PillarAction(LivingEntity entity) {
        this.entity = entity;
        this.eventScheduler = CapabilityUtils.getLevelEventScheduler((Level)entity.level());
    }

    @Override
    public int perform() {
        Level level = this.entity.level();
        if (!(level instanceof ServerLevel)) {
            return 80;
        }
        List<BlockPos> pillarPositions = this.getPillarPositions();
        SoundUtils.playSound((ServerLevel)((ServerLevel)level), (Vec3)this.entity.position(), (SoundEvent)((SoundEvent)BMDSounds.OBSIDILITH_PREPARE_ATTACK.get()), (SoundSource)SoundSource.HOSTILE, (float)3.0f, (float)1.4f, (double)64.0, null);
        pillarPositions.forEach(blockPos -> {
            MathUtils.lineCallback((Vec3)MobUtils.eyePos((Entity)this.entity), (Vec3)VecUtils.asVec3((BlockPos)blockPos).add(0.5, 0.5, 0.5), (int)13, (vec3, integer) -> ParticleUtils.spawnParticle((ServerLevel)((ServerLevel)level), (ParticleOptions)((ParticleOptions)BMDParticles.PILLAR_SPAWN_INDICATOR_2.get()), (Vec3)vec3, (Vec3)Vec3.ZERO, (int)0, (double)0.0));
            ParticleUtils.spawnParticle((ServerLevel)((ServerLevel)level), (ParticleOptions)((ParticleOptions)BMDParticles.PILLAR_SPAWN_INDICATOR.get()), (Vec3)VecUtils.asVec3((BlockPos)blockPos.above(5)), (Vec3)new Vec3(0.3, 3.0, 0.3), (int)20, (double)0.0);
        });
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> pillarPositions.forEach(blockPos -> this.buildPillar((BlockPos)blockPos, (ServerLevel)level)), 40, 1, () -> !this.entity.isAlive()));
        return 100;
    }

    private List<BlockPos> getPillarPositions() {
        int numPillars = 4;
        ArrayList<BlockPos> pillars = new ArrayList<BlockPos>();
        for (int i = 0; i < numPillars; ++i) {
            Vec3 position = VecUtils.planeProject((Vec3)RandomUtils.randVec(), (Vec3)VecUtils.yAxis).normalize().scale(13.0).add(this.entity.position());
            BlockPos above = BMDUtils.findGroundBelow(this.entity.level(), BlockPos.containing((Position)position).above(14), pos -> true);
            BlockPos ground = BMDUtils.findGroundBelow(this.entity.level(), above, pos -> true);
            if ((double)(above.getY() - ground.getY()) > 15.0) continue;
            pillars.add(ground);
        }
        return pillars;
    }

    private void buildPillar(BlockPos pos, ServerLevel serverLevel) {
        int pillarHeight = 2;
        IntStream.range(0, pillarHeight).forEach(i -> this.entity.level().setBlockAndUpdate(pos.above(i), Blocks.OBSIDIAN.defaultBlockState()));
        BlockPos pillarTop = pos.above(pillarHeight);
        this.entity.level().setBlockAndUpdate(pillarTop, ((Block)BMDBlocks.OBSIDILITH_RUNE.get()).defaultBlockState());
        SoundUtils.playSound((ServerLevel)serverLevel, (Vec3)VecUtils.asVec3((BlockPos)pos), (SoundEvent)SoundEvents.BASALT_PLACE, (SoundSource)SoundSource.HOSTILE, (float)1.0f, (double)16.0, null);
    }
}

