/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity;

import com.cerbon.bosses_of_mass_destruction.animation.PauseAnimationTimer;
import com.cerbon.bosses_of_mass_destruction.client.render.BillboardRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.CompositeRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.ConditionalRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.FrameLimiter;
import com.cerbon.bosses_of_mass_destruction.client.render.FullRenderLight;
import com.cerbon.bosses_of_mass_destruction.client.render.LerpedPosRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.PetalBladeParticleRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.PetalBladeRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.SimpleEntityRenderer;
import com.cerbon.bosses_of_mass_destruction.config.BMDConfig;
import com.cerbon.bosses_of_mass_destruction.entity.GeoModel;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletCodeAnimations;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletEnergyRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletLaserRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletOverlay;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletTextureProvider;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.LaserParticleRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.BoundedLighting;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.EternalNightRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichBoneLight;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichCodeAnimations;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichKillCounter;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithArmorRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithBoneLight;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.NoRedOnDeathOverlay;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.SporeBallOverlay;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.SporeBallSizeRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.SporeCodeAnimations;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomBoneLight;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomCodeAnimations;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomSpikeRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.util.SimpleLivingGeoRenderer;
import com.cerbon.bosses_of_mass_destruction.item.custom.ChargedEnderPearlEntity;
import com.cerbon.bosses_of_mass_destruction.item.custom.SoulStarEntity;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.particle.ParticleFactories;
import com.cerbon.bosses_of_mass_destruction.projectile.MagicMissileProjectile;
import com.cerbon.bosses_of_mass_destruction.projectile.PetalBladeProjectile;
import com.cerbon.bosses_of_mass_destruction.projectile.SporeBallProjectile;
import com.cerbon.bosses_of_mass_destruction.projectile.comet.CometCodeAnimations;
import com.cerbon.bosses_of_mass_destruction.projectile.comet.CometProjectile;
import com.cerbon.cerbons_api.api.general.data.WeakHashPredicate;
import com.cerbon.cerbons_api.api.general.particle.ClientParticleBuilder;
import com.cerbon.cerbons_api.api.registry.RegistryEntry;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistries;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistry;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.Vec3Colors;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import com.mojang.blaze3d.Blaze3D;
import java.util.function.Predicate;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BMDEntities {
    public static final BMDConfig mobConfig = (BMDConfig)AutoConfig.getConfigHolder(BMDConfig.class).getConfig();
    public static final ResourcefulRegistry<EntityType<?>> ENTITY_TYPES = ResourcefulRegistries.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"bosses_of_mass_destruction");
    public static final RegistryEntry<EntityType<LichEntity>> LICH = ENTITY_TYPES.register("lich", () -> EntityType.Builder.of((entityType, level) -> new LichEntity((EntityType<? extends LichEntity>)entityType, level, BMDEntities.mobConfig.lichConfig), (MobCategory)MobCategory.MONSTER).sized(1.8f, 3.0f).updateInterval(1).build(ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"lich").toString()));
    public static final RegistryEntry<EntityType<MagicMissileProjectile>> MAGIC_MISSILE = ENTITY_TYPES.register("blue_fireball", () -> EntityType.Builder.of(MagicMissileProjectile::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"blue_fireball").toString()));
    public static final RegistryEntry<EntityType<CometProjectile>> COMET = ENTITY_TYPES.register("comet", () -> EntityType.Builder.of(CometProjectile::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"comet").toString()));
    public static final RegistryEntry<EntityType<SoulStarEntity>> SOUL_STAR = ENTITY_TYPES.register("soul_star", () -> EntityType.Builder.of(SoulStarEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"soul_star").toString()));
    public static final RegistryEntry<EntityType<ChargedEnderPearlEntity>> CHARGED_ENDER_PEARL = ENTITY_TYPES.register("charged_ender_pearl", () -> EntityType.Builder.of(ChargedEnderPearlEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"charged_ender_pearl").toString()));
    public static final RegistryEntry<EntityType<ObsidilithEntity>> OBSIDILITH = ENTITY_TYPES.register("obsidilith", () -> EntityType.Builder.of((entityType, level) -> new ObsidilithEntity((EntityType<? extends PathfinderMob>)entityType, level, BMDEntities.mobConfig.obsidilithConfig), (MobCategory)MobCategory.MONSTER).sized(2.0f, 4.4f).fireImmune().build(ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"obsidilith").toString()));
    public static final RegistryEntry<EntityType<GauntletEntity>> GAUNTLET = ENTITY_TYPES.register("gauntlet", () -> EntityType.Builder.of((entityType, level) -> new GauntletEntity((EntityType<? extends PathfinderMob>)entityType, level, BMDEntities.mobConfig.gauntletConfig), (MobCategory)MobCategory.MONSTER).sized(5.0f, 4.0f).fireImmune().build(ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"gauntlet").toString()));
    public static final RegistryEntry<EntityType<VoidBlossomEntity>> VOID_BLOSSOM = ENTITY_TYPES.register("void_blossom", () -> EntityType.Builder.of((entityType, level) -> new VoidBlossomEntity((EntityType<? extends PathfinderMob>)entityType, level, BMDEntities.mobConfig.voidBlossomConfig), (MobCategory)MobCategory.MONSTER).sized(8.0f, 10.0f).fireImmune().clientTrackingRange(3).build(ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"void_blossom").toString()));
    public static final RegistryEntry<EntityType<SporeBallProjectile>> SPORE_BALL = ENTITY_TYPES.register("spore_ball", () -> EntityType.Builder.of(SporeBallProjectile::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"spore_ball").toString()));
    public static final RegistryEntry<EntityType<PetalBladeProjectile>> PETAL_BLADE = ENTITY_TYPES.register("petal_blade", () -> EntityType.Builder.of(PetalBladeProjectile::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"petal_blade").toString()));
    public static final LichKillCounter killCounter = new LichKillCounter(BMDEntities.mobConfig.lichConfig.summonMechanic);

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        PauseAnimationTimer pauseSecondTimer = new PauseAnimationTimer(Blaze3D::getTime, () -> Minecraft.getInstance().isPaused());
        EntityRenderers.register((EntityType)((EntityType)LICH.get()), context -> {
            ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"textures/entity/lich.png");
            return new SimpleLivingGeoRenderer<LichEntity>(context, new GeoModel<LichEntity>(lichEntity -> ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"geo/lich.geo.json"), entity -> texture, ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"animations/lich.animation.json"), new LichCodeAnimations(), RenderType::entityCutoutNoCull), new BoundedLighting(5), new LichBoneLight(), new EternalNightRenderer(), null, null, true);
        });
        EntityRenderers.register((EntityType)((EntityType)OBSIDILITH.get()), context -> {
            ObsidilithBoneLight runeColorHandler = new ObsidilithBoneLight();
            GeoModel<ObsidilithEntity> modelProvider = new GeoModel<ObsidilithEntity>(entity -> ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"geo/obsidilith.geo.json"), entity -> ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"textures/entity/obsidilith.png"), ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"animations/obsidilith.animation.json"), (animatable, data, geoModel) -> {}, RenderType::entityCutout);
            ObsidilithArmorRenderer armorRenderer = new ObsidilithArmorRenderer(modelProvider, context);
            return new SimpleLivingGeoRenderer<ObsidilithEntity>(context, modelProvider, null, runeColorHandler, new CompositeRenderer(armorRenderer, runeColorHandler), armorRenderer, null, false);
        });
        EntityRenderers.register((EntityType)((EntityType)COMET.get()), context -> new SimpleLivingGeoRenderer<CometProjectile>(context, new GeoModel<CometProjectile>(geoAnimatable -> ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"geo/comet.geo.json"), entity -> ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"textures/entity/comet.png"), ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"animations/comet.animation.json"), new CometCodeAnimations(), RenderType::entityCutout), new FullRenderLight(), null, new ConditionalRenderer(new WeakHashPredicate(() -> new FrameLimiter(60.0f, pauseSecondTimer)::canDoFrame), new LerpedPosRenderer(vec3 -> ParticleFactories.cometTrail().build(vec3.add(RandomUtils.randVec().scale(0.5)), Vec3.ZERO))), null, null, true));
        EntityRenderers.register((EntityType)((EntityType)SOUL_STAR.get()), context -> new ThrownItemRenderer(context, 1.0f, true));
        EntityRenderers.register((EntityType)((EntityType)CHARGED_ENDER_PEARL.get()), ThrownItemRenderer::new);
        ResourceLocation missileTexture = ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"textures/entity/blue_magic_missile.png");
        RenderType magicMissileRenderType = RenderType.entityCutoutNoCull((ResourceLocation)missileTexture);
        EntityRenderers.register((EntityType)((EntityType)MAGIC_MISSILE.get()), context -> new SimpleEntityRenderer<MagicMissileProjectile>(context, new CompositeRenderer(new BillboardRenderer<MagicMissileProjectile>(context.getEntityRenderDispatcher(), magicMissileRenderType, f -> 0.5f), new ConditionalRenderer(new WeakHashPredicate(() -> new FrameLimiter(20.0f, pauseSecondTimer)::canDoFrame), new LerpedPosRenderer(vec3 -> ParticleFactories.soulFlame().build(vec3.add(RandomUtils.randVec().scale(0.25)), Vec3.ZERO)))), entity -> missileTexture, new FullRenderLight()));
        EntityRenderers.register((EntityType)((EntityType)GAUNTLET.get()), context -> {
            GeoModel<GauntletEntity> modelProvider = new GeoModel<GauntletEntity>(entity -> ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"geo/gauntlet.geo.json"), new GauntletTextureProvider(), ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"animations/gauntlet.animation.json"), new GauntletCodeAnimations(), RenderType::entityCutout);
            GauntletEnergyRenderer energyRenderer = new GauntletEnergyRenderer(modelProvider, context);
            GauntletOverlay overlayOverride = new GauntletOverlay();
            return new SimpleLivingGeoRenderer<GauntletEntity>(context, modelProvider, null, null, new CompositeRenderer(new GauntletLaserRenderer(), new ConditionalRenderer<GauntletEntity>((Predicate<GauntletEntity>)new WeakHashPredicate(() -> new FrameLimiter(20.0f, pauseSecondTimer)::canDoFrame), new LaserParticleRenderer()), energyRenderer, overlayOverride), energyRenderer, overlayOverride, false);
        });
        EntityRenderers.register((EntityType)((EntityType)VOID_BLOSSOM.get()), context -> {
            ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"textures/entity/void_blossom.png");
            GeoModel<VoidBlossomEntity> modelProvider = new GeoModel<VoidBlossomEntity>(entity -> ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"geo/void_blossom.geo.json"), entity -> texture, ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"animations/void_blossom.animation.json"), new VoidBlossomCodeAnimations(), RenderType::entityCutout);
            VoidBlossomBoneLight boneLight = new VoidBlossomBoneLight();
            NoRedOnDeathOverlay overlay = new NoRedOnDeathOverlay();
            return new SimpleLivingGeoRenderer<VoidBlossomEntity>(context, modelProvider, null, boneLight, new CompositeRenderer(new VoidBlossomSpikeRenderer(), boneLight, overlay), null, overlay, false);
        });
        EntityRenderers.register((EntityType)((EntityType)SPORE_BALL.get()), context -> {
            SporeBallOverlay explosionFlasher = new SporeBallOverlay();
            return new SimpleLivingGeoRenderer<SporeBallProjectile>(context, new GeoModel<SporeBallProjectile>(geoAnimatable -> ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"geo/comet.geo.json"), entity -> ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"textures/entity/spore.png"), ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"animations/comet.animation.json"), new SporeCodeAnimations(), RenderType::entityCutout), new FullRenderLight(), null, new CompositeRenderer(new ConditionalRenderer(new WeakHashPredicate(() -> new FrameLimiter(60.0f, pauseSecondTimer)::canDoFrame), new LerpedPosRenderer(vec3 -> {
                ClientParticleBuilder projectileParticles = new ClientParticleBuilder((ParticleOptions)BMDParticles.OBSIDILITH_BURST.get()).color(Vec3Colors.GREEN).colorVariation(0.4).scale(0.5f).brightness(0xF000F0);
                projectileParticles.build(vec3.add(RandomUtils.randVec().scale(0.25)), VecUtils.yAxis.scale(0.1));
            })), explosionFlasher, new SporeBallSizeRenderer()), null, explosionFlasher, true);
        });
        ResourceLocation petalTexture = ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"textures/entity/petal_blade.png");
        RenderType petalBladeRenderType = RenderType.entityCutoutNoCull((ResourceLocation)petalTexture);
        EntityRenderers.register((EntityType)((EntityType)PETAL_BLADE.get()), context -> new SimpleEntityRenderer<PetalBladeProjectile>(context, new CompositeRenderer(new PetalBladeRenderer(context.getEntityRenderDispatcher(), petalBladeRenderType), new ConditionalRenderer(new WeakHashPredicate(() -> new FrameLimiter(30.0f, pauseSecondTimer)::canDoFrame), new PetalBladeParticleRenderer())), entity -> petalTexture, new FullRenderLight()));
    }

    public static void register() {
        ENTITY_TYPES.register();
    }
}

