/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.block.custom;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.entity.BMDEntities;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithEntity;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.general.particle.ClientParticleBuilder;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ObsidilithSummonBlock
extends Block {
    public static final BooleanProperty eye = BlockStateProperties.EYE;
    protected final VoxelShape frameShape = ObsidilithSummonBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected final VoxelShape eyeShape = ObsidilithSummonBlock.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected final VoxelShape frameWithEyeShape = Shapes.or((VoxelShape)this.frameShape, (VoxelShape)this.eyeShape);

    public ObsidilithSummonBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)eye, (Comparable)Boolean.valueOf(false)));
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.getValue((Property)eye) != false ? this.frameWithEyeShape : this.frameShape;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)eye, (Comparable)Boolean.valueOf(false));
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)eye) != false ? 15 : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{eye});
    }

    public static void onEnderEyeUsed(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        BlockPos blockPos;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(blockPos = context.getClickedPos());
        if (blockState.is((Block)BMDBlocks.OBSIDILITH_SUMMON_BLOCK.get()) && !((Boolean)blockState.getValue((Property)EndPortalFrameBlock.HAS_EYE)).booleanValue()) {
            EventScheduler eventScheduler = CapabilityUtils.getLevelEventScheduler((Level)level);
            if (level.isClientSide) {
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
                ObsidilithSummonBlock.addSummonEntityEffects(eventScheduler, blockPos);
            } else {
                BlockState blockState2 = (BlockState)blockState.setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(true));
                ObsidilithSummonBlock.pushEntitiesUp((BlockState)blockState, (BlockState)blockState2, (LevelAccessor)level, (BlockPos)blockPos);
                level.setBlock(blockPos, blockState2, 2);
                context.getItemInHand().shrink(1);
                level.levelEvent(1503, blockPos, 0);
                ObsidilithSummonBlock.addSummonEntityEvent(eventScheduler, level, blockPos);
                cir.setReturnValue((Object)InteractionResult.PASS);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addSummonEntityEffects(EventScheduler eventScheduler, BlockPos blockPos) {
        Vec3 centralPos = VecUtils.asVec3((BlockPos)blockPos.above()).add(VecUtils.unit.scale(0.5));
        Vec3 particleVel = VecUtils.yAxis.scale(-0.03);
        eventScheduler.addEvent((IEvent)new TimedEvent(() -> Particles.activateParticleFactory.build(centralPos.add(RandomUtils.randVec().scale(2.0)), particleVel), 0, 80, () -> false));
    }

    private static void addSummonEntityEvent(EventScheduler eventScheduler, Level level, BlockPos blockPos) {
        Vec3 pos = VecUtils.asVec3((BlockPos)blockPos).add(new Vec3(0.5, 0.0, 0.5));
        eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
            level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
            ObsidilithEntity obsidilithEntity = (ObsidilithEntity)((EntityType)BMDEntities.OBSIDILITH.get()).create(level);
            if (obsidilithEntity != null) {
                obsidilithEntity.syncPacketPositionCodec(pos.x, pos.y, pos.z);
                obsidilithEntity.absMoveTo(pos.x, pos.y, pos.z);
                level.addFreshEntity((Entity)obsidilithEntity);
            }
        }, 100));
    }

    public static class Particles {
        public static final ClientParticleBuilder activateParticleFactory = new ClientParticleBuilder((ParticleOptions)BMDParticles.PILLAR_RUNE.get()).scale(f -> Float.valueOf((float)Math.sin((double)f.floatValue() * Math.PI) * 0.05f)).age(30);
    }
}

