/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.teammetallurgy.aquaculture.block.FarmlandMoistBlock;
import com.teammetallurgy.aquaculture.block.NeptunesBountyBlock;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.WormFarmBlock;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.item.BlockItemWithoutLevelRenderer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AquaBlocks {
    public static final DeferredRegister.Blocks BLOCK_DEFERRED = DeferredRegister.createBlocks((String)"aquaculture");
    public static final DeferredBlock<Block> FARMLAND = AquaBlocks.register(FarmlandMoistBlock::new, "farmland", null);
    public static final DeferredBlock<Block> NEPTUNIUM_BLOCK = AquaBlocks.register(() -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(5.0f, 6.0f).sound(SoundType.METAL)), "neptunium_block");
    public static final DeferredBlock<Block> NEPTUNES_BOUNTY = AquaBlocks.registerWithRenderer(NeptunesBountyBlock::new, "neptunes_bounty", new Item.Properties());
    public static final DeferredBlock<Block> TACKLE_BOX = AquaBlocks.registerWithRenderer(TackleBoxBlock::new, "tackle_box", new Item.Properties());
    public static final DeferredBlock<Block> WORM_FARM = AquaBlocks.register(WormFarmBlock::new, "worm_farm");

    public static DeferredBlock<Block> register(Supplier<Block> supplier, @Nonnull String name) {
        return AquaBlocks.register(supplier, name, new Item.Properties());
    }

    public static DeferredBlock<Block> register(Supplier<Block> supplier, @Nonnull String name, @Nullable Item.Properties properties) {
        DeferredBlock block = BLOCK_DEFERRED.register(name, supplier);
        if (properties == null) {
            AquaItems.register(() -> new BlockItem((Block)block.get(), new Item.Properties()), name);
        } else {
            AquaItems.registerWithTab(() -> new BlockItem((Block)block.get(), properties), name);
        }
        return block;
    }

    public static DeferredBlock<Block> registerWithRenderer(Supplier<Block> supplier, @Nonnull String name, @Nullable Item.Properties properties) {
        DeferredBlock block = BLOCK_DEFERRED.register(name, supplier);
        if (properties == null) {
            AquaItems.register(() -> new BlockItemWithoutLevelRenderer((Block)block.get(), new Item.Properties()), name);
        } else {
            AquaItems.registerWithTab(() -> new BlockItemWithoutLevelRenderer((Block)block.get(), properties), name);
        }
        return block;
    }
}

