/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.xmod.mi;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.config.MIServerConfig;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.config.AFConfig;
import com.glodblock.github.appflux.xmod.mi.LongEnergyCap;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class MIEnergyCap
extends LongEnergyCap
implements MIEnergyStorage {
    public static final BlockCapability<MIEnergyStorage, Direction> CAP = EnergyApi.SIDED;

    protected MIEnergyCap(IStorageService storage, IActionSource source) {
        super(storage, source);
    }

    public static MIEnergyStorage of(@Nullable IStorageService storage, IActionSource source) {
        if (storage == null) {
            return EnergyApi.EMPTY;
        }
        return new MIEnergyCap(storage, source);
    }

    public static long send(ILongEnergyStorage acceptor, IStorageService storage, IActionSource source) {
        long drainedFE;
        long ratio = MIEnergyCap.ratio();
        long ioEU = AFConfig.getFluxAccessorIO() / ratio;
        long toAddEu = acceptor.receive(ioEU, true);
        long toAddFE = toAddEu * ratio;
        if (toAddFE > 0L && (drainedFE = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), toAddFE, Actionable.MODULATE, source)) > 0L) {
            long drainedEU = drainedFE / ratio;
            long addedEU = acceptor.receive(drainedEU, false);
            long leftFE = (drainedEU - addedEU) * ratio;
            if (leftFE > 0L) {
                storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), leftFE, Actionable.MODULATE, source);
            }
            return drainedEU * ratio;
        }
        return 0L;
    }

    @Override
    public long receive(long maxReceive, boolean simulate) {
        int ratio = MIEnergyCap.ratio();
        maxReceive *= (long)ratio;
        if ((long)ratio > 1L) {
            maxReceive = super.receive(maxReceive, true) / (long)ratio * (long)ratio;
        }
        return super.receive(maxReceive, simulate) / (long)ratio;
    }

    @Override
    public long extract(long maxExtract, boolean simulate) {
        int ratio = MIEnergyCap.ratio();
        maxExtract *= (long)ratio;
        if ((long)ratio > 1L) {
            maxExtract = super.extract(maxExtract, true) / (long)ratio * (long)ratio;
        }
        return super.extract(maxExtract, simulate) / (long)ratio;
    }

    @Override
    public long getAmount() {
        return super.getAmount() / (long)MIEnergyCap.ratio();
    }

    @Override
    public long getCapacity() {
        return super.getCapacity() / (long)MIEnergyCap.ratio();
    }

    public boolean canConnect(CableTier cableTier) {
        return true;
    }

    private static int ratio() {
        return MIServerConfig.INSTANCE.forgeEnergyPerEu.getAsInt();
    }
}

