/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.xmod.mi;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.config.AFConfig;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.energy.EmptyEnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class LongEnergyCap
implements ILongEnergyStorage {
    protected final IStorageService storage;
    protected final IActionSource source;
    protected static final ILongEnergyStorage EMPTY = ILongEnergyStorage.of((IEnergyStorage)EmptyEnergyStorage.INSTANCE);
    public static final BlockCapability<ILongEnergyStorage, Direction> CAP = ILongEnergyStorage.BLOCK;

    protected LongEnergyCap(IStorageService storage, IActionSource source) {
        this.storage = storage;
        this.source = source;
    }

    public static ILongEnergyStorage of(@Nullable IStorageService storage, IActionSource source) {
        if (storage == null) {
            return EMPTY;
        }
        return new LongEnergyCap(storage, source);
    }

    public static long send(ILongEnergyStorage acceptor, IStorageService storage, IActionSource source) {
        long drained;
        long toAdd = acceptor.receive(AFConfig.getFluxAccessorIO(), true);
        if (toAdd > 0L && (drained = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), toAdd, Actionable.MODULATE, source)) > 0L) {
            long actuallyDrained = acceptor.receive(drained, false);
            long differ = drained - actuallyDrained;
            if (differ > 0L) {
                storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), differ, Actionable.MODULATE, source);
            }
            return actuallyDrained;
        }
        return 0L;
    }

    public long receive(long maxReceive, boolean simulate) {
        return this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), maxReceive, Actionable.ofSimulate((boolean)simulate), this.source);
    }

    public long extract(long maxExtract, boolean simulate) {
        return this.storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), maxExtract, Actionable.ofSimulate((boolean)simulate), this.source);
    }

    public long getAmount() {
        return this.storage.getCachedInventory().get((AEKey)FluxKey.of(EnergyType.FE));
    }

    public long getCapacity() {
        long space = this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), 0x7FFFFFFFFFFFFFFEL, Actionable.SIMULATE, this.source);
        return space + this.getAmount();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

