/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.energy;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnit;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import com.glodblock.github.appflux.common.me.energy.EnergyCapCache;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.config.AFConfig;
import com.glodblock.github.appflux.util.AFUtil;
import com.glodblock.github.appflux.xmod.fluxnetwork.FluxNetworkCap;
import com.glodblock.github.appflux.xmod.mek.MekEnergyCap;
import com.glodblock.github.appflux.xmod.mi.LongEnergyCap;
import com.glodblock.github.appflux.xmod.mi.MIEnergyCap;
import com.glodblock.github.glodium.util.GlodUtil;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class EnergyHandler {
    private static final ArrayList<Pair<BlockCapability<?, Direction>, Handler<?>>> HANDLERS = new ArrayList();
    private static final Handler<IEnergyStorage> DEFAULT = (accepter, storage, source) -> {
        long drained;
        int toAdd = accepter.receiveEnergy(AFUtil.clampLong(AFConfig.getFluxAccessorIO()), true);
        if (toAdd > 0 && (drained = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), (long)toAdd, Actionable.MODULATE, source)) > 0L) {
            int actuallyDrained = accepter.receiveEnergy((int)drained, false);
            long differ = drained - (long)actuallyDrained;
            if (differ > 0L) {
                storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), differ, Actionable.MODULATE, source);
            }
            return actuallyDrained;
        }
        return 0L;
    };

    public static <T> void addHandler(BlockCapability<T, Direction> cap, Handler<T> handler) {
        HANDLERS.add(Pair.of(cap, handler));
    }

    public static <T> long send(@NotNull EnergyCapCache cache, Direction side, @NotNull IStorageService storage, @NotNull IActionSource source) {
        for (Pair<BlockCapability<?, Direction>, Handler<?>> entry : HANDLERS) {
            Object cap = cache.getEnergyCap((BlockCapability)entry.left(), side);
            if (cap == null) continue;
            return ((Handler)entry.right()).send(cap, storage, source);
        }
        IEnergyStorage cap = (IEnergyStorage)cache.getEnergyCap(Capabilities.EnergyStorage.BLOCK, side);
        if (cap != null) {
            return DEFAULT.send(cap, storage, source);
        }
        return -1L;
    }

    public static void chargeNetwork(@NotNull IEnergyService energy, @NotNull IStorageService storage, @NotNull IActionSource source) {
        double toAdd = Math.floor(2.147483647E9 - energy.injectPower(2.147483647E9, Actionable.SIMULATE));
        long toDrain = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), (long)PowerUnit.AE.convertTo(PowerUnit.FE, toAdd), Actionable.MODULATE, source);
        energy.injectPower((double)toDrain, Actionable.MODULATE);
    }

    static {
        if (GlodUtil.checkMod((String)"mekanism")) {
            EnergyHandler.addHandler(MekEnergyCap.CAP, MekEnergyCap::send);
        }
        if (GlodUtil.checkMod((String)"grandpower") && AFConfig.miSupport()) {
            EnergyHandler.addHandler(LongEnergyCap.CAP, LongEnergyCap::send);
        }
        if (GlodUtil.checkMod((String)"modern_industrialization") && AFConfig.miSupport()) {
            EnergyHandler.addHandler(MIEnergyCap.CAP, MIEnergyCap::send);
        }
        if (GlodUtil.checkMod((String)"fluxnetworks")) {
            EnergyHandler.addHandler(FluxNetworkCap.CAP, FluxNetworkCap::send);
        }
    }

    public static interface Handler<T> {
        public long send(@NotNull T var1, @NotNull IStorageService var2, @NotNull IActionSource var3);
    }
}

