/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.objects;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.api.EnchantableItem;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TomeItem
extends BookItem
implements EnchantableItem {
    final ItemStack rep;

    public TomeItem(Item rep) {
        super(new Item.Properties());
        this.rep = new ItemStack((ItemLike)rep);
        ApothicEnchanting.TYPED_BOOKS.add(this);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return stack.getCount() == 1;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        if (this.rep.isEmpty()) {
            return ApothicEnchanting.TYPED_BOOKS.stream().filter(b -> b != this).allMatch(b -> !b.isPrimaryItemFor(b.getDefaultInstance(), enchantment));
        }
        return ((Enchantment)enchantment.value()).isPrimaryItem(this.rep);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)TooltipUtil.lang("info", BuiltInRegistries.ITEM.getKey((Object)this).getPath(), new Object[0]).withStyle(ChatFormatting.GRAY));
        if (stack.isEnchanted()) {
            tooltip.add((Component)TooltipUtil.lang("info", "tome_error", new Object[0]).withStyle(ChatFormatting.RED));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.isEnchanted()) {
            ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK, stack.getCount());
            EnchantmentHelper.setEnchantments((ItemStack)book, (ItemEnchantments)EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
            return InteractionResultHolder.consume((Object)book);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public ItemStack applyEnchantments(ItemStack stack, List<EnchantmentInstance> enchantments) {
        stack = stack.transmuteCopy((ItemLike)Items.ENCHANTED_BOOK);
        for (EnchantmentInstance inst : enchantments) {
            stack.enchant(inst.enchantment, inst.level);
        }
        return stack;
    }
}

