/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.objects;

import com.google.common.collect.Lists;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.AnvilUpdateEvent;

public class ScrappingTomeItem
extends BookItem {
    static Random rand = new Random();

    public ScrappingTomeItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (stack.isEnchanted()) {
            return;
        }
        tooltip.add((Component)TooltipUtil.lang("info", "scrap_tome", new Object[0]).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)TooltipUtil.lang("info", "scrap_tome2", new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    public static boolean updateAnvil(AnvilUpdateEvent ev) {
        ItemStack weapon = ev.getLeft();
        ItemStack book = ev.getRight();
        if (!(book.getItem() instanceof ScrappingTomeItem) || book.isEnchanted() || !weapon.isEnchanted()) {
            return false;
        }
        ItemEnchantments.Mutable wepEnch = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)weapon));
        int size = Mth.ceil((double)((double)wepEnch.keySet().size() / 2.0));
        ArrayList keys = Lists.newArrayList((Iterable)wepEnch.keySet());
        long seed = 1831L;
        for (Holder e : keys) {
            seed ^= (long)e.getKey().hashCode();
        }
        rand.setSeed(seed ^= (long)ev.getPlayer().getEnchantmentSeed());
        while (wepEnch.keySet().size() > size) {
            Holder lost = (Holder)keys.get(rand.nextInt(keys.size()));
            wepEnch.keySet().remove(lost);
            keys.remove(lost);
        }
        ItemStack out = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        EnchantmentHelper.setEnchantments((ItemStack)out, (ItemEnchantments)wepEnch.toImmutable());
        ev.setMaterialCost(1);
        ev.setCost((long)(wepEnch.keySet().size() * 6));
        ev.setOutput(out);
        return true;
    }
}

