/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments;

import dev.shadowsoffire.apothic_enchanting.Ench;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.commons.lang3.mutable.MutableFloat;

public class CrescendoHooks {
    public static void prepareCrescendoShots(LivingEntity shooter, ItemStack crossbow) {
        if (EnchantmentHelper.has((ItemStack)crossbow, Ench.EnchantEffects.CRESCENDO)) {
            MutableFloat f = new MutableFloat();
            EnchantmentHelper.runIterationOnItem((ItemStack)crossbow, (ench, level) -> ((Enchantment)ench.value()).modifyItemFilteredCount(Ench.EnchantEffects.CRESCENDO, (ServerLevel)shooter.level(), level, crossbow, f));
            if (f.intValue() > 0) {
                crossbow.set(Ench.Components.CRESCENDO_SHOTS, (Object)f.intValue());
                crossbow.set(Ench.Components.CRESCENDO_PROJECTILES, (Object)((ChargedProjectiles)crossbow.get(DataComponents.CHARGED_PROJECTILES)));
            }
        }
    }

    public static void reloadFromCrescendoCharge(ServerLevel serverLevel, ItemStack crossbow) {
        int shots = (Integer)crossbow.getOrDefault(Ench.Components.CRESCENDO_SHOTS, (Object)0);
        if (shots > 0) {
            ChargedProjectiles projectiles = (ChargedProjectiles)crossbow.get(Ench.Components.CRESCENDO_PROJECTILES);
            crossbow.set(DataComponents.CHARGED_PROJECTILES, (Object)projectiles);
            if (shots == 1) {
                crossbow.remove(Ench.Components.CRESCENDO_SHOTS);
                crossbow.remove(Ench.Components.CRESCENDO_PROJECTILES);
            } else {
                crossbow.set(Ench.Components.CRESCENDO_SHOTS, (Object)(shots - 1));
            }
        }
    }

    public static void markGeneratedArrows(Projectile arrow, ItemStack crossbow) {
        if (crossbow.has(Ench.Components.CRESCENDO_SHOTS) && arrow instanceof AbstractArrow) {
            AbstractArrow arr = (AbstractArrow)arrow;
            arr.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
    }
}

