/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.data;

import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.placebo.loot.StackLootEntry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootProvider
extends LootTableProvider {
    private LootProvider(PackOutput output, Set<ResourceKey<LootTable>> requiredTables, List<LootTableProvider.SubProviderEntry> subProviders, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, requiredTables, subProviders, registries);
    }

    public static LootProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        return new LootProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLoot::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(BoonLoot::new, LootContextParamSets.ADVANCEMENT_LOCATION)), registries);
    }

    private static StackEntryBuilder item(Item item, int min, int max) {
        return new StackEntryBuilder(item.getDefaultInstance()).count(min, max);
    }

    public static class StackEntryBuilder
    extends LootPoolSingletonContainer.Builder<StackEntryBuilder> {
        protected final ItemStack stack;
        protected int min = -1;
        protected int max = -1;

        public StackEntryBuilder(ItemStack stack) {
            this.stack = stack;
        }

        public StackEntryBuilder count(int min, int max) {
            this.min = min;
            this.max = max;
            return this;
        }

        protected StackEntryBuilder getThis() {
            return this;
        }

        public LootPoolEntryContainer build() {
            if (this.min == -1) {
                this.min = this.stack.getCount();
            }
            if (this.max == -1) {
                this.max = this.stack.getCount();
            }
            return new StackLootEntry(this.stack, this.min, this.max, this.weight, this.quality, this.getConditions(), this.getFunctions());
        }
    }

    public record BoonLoot(HolderLookup.Provider registries) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            HolderLookup.RegistryLookup biomes = this.registries.lookupOrThrow(Registries.BIOME);
            output.accept(Ench.LootTables.BOON_STONE_DROPS, LootTable.lootTable().withPool(LootPool.lootPool().when(this.doesNotHaveSilkTouch()).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)0.02f)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.RAW_COPPER, 3, 5).setWeight(100)).apply((LootItemFunction.Builder)this.fortuneBonus(0.15f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)((StackEntryBuilder)LootProvider.item(Items.RAW_IRON, 3, 5).setWeight(100)).setQuality(1)).apply((LootItemFunction.Builder)this.fortuneBonus(0.15f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.COAL, 2, 10).setWeight(100)).apply((LootItemFunction.Builder)this.fortuneBonus(0.2f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)((StackEntryBuilder)LootProvider.item(Items.RAW_GOLD, 2, 5).setWeight(20)).setQuality(2)).apply((LootItemFunction.Builder)this.fortuneBonus(0.15f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)((StackEntryBuilder)LootProvider.item(Items.LAPIS_LAZULI, 2, 7).setWeight(20)).setQuality(2)).apply((LootItemFunction.Builder)this.fortuneBonus(0.15f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.DIAMOND, 1, 2).setWeight(5)).setQuality(3)).apply(this.fortuneBonus(0.08f))).withPool(LootPool.lootPool().when(this.hasSilkTouch()).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)0.02f)).add((LootPoolEntryContainer.Builder)LootProvider.item(Items.COPPER_ORE, 1, 3).setWeight(100)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.IRON_ORE, 1, 3).setWeight(100)).setQuality(1)).add((LootPoolEntryContainer.Builder)LootProvider.item(Items.COAL_ORE, 2, 5).setWeight(100)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.GOLD_ORE, 1, 3).setWeight(20)).setQuality(2)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.LAPIS_ORE, 2, 5).setWeight(20)).setQuality(2)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.DIAMOND_ORE, 1, 1).setWeight(5)).setQuality(3))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setY(MinMaxBounds.Doubles.atLeast((double)32.0)).setBiomes((HolderSet)biomes.getOrThrow(BiomeTags.IS_MOUNTAIN))).and(this.doesNotHaveSilkTouch())).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.EMERALD, 1, 2).setWeight(15)).apply((LootItemFunction.Builder)this.fortuneBonus(0.08f))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(85))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setY(MinMaxBounds.Doubles.atLeast((double)32.0)).setBiomes((HolderSet)biomes.getOrThrow(BiomeTags.IS_MOUNTAIN))).and(this.hasSilkTouch())).add((LootPoolEntryContainer.Builder)LootProvider.item(Items.EMERALD_ORE, 1, 1).setWeight(15)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(85))));
            output.accept(Ench.LootTables.BOON_DEEPSLATE_DROPS, LootTable.lootTable().withPool(LootPool.lootPool().when(this.doesNotHaveSilkTouch()).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)0.02f)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.RAW_IRON, 3, 5).setWeight(80)).apply((LootItemFunction.Builder)this.fortuneBonus(0.15f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)((StackEntryBuilder)LootProvider.item(Items.RAW_GOLD, 1, 5).setWeight(100)).setQuality(1)).apply((LootItemFunction.Builder)this.fortuneBonus(0.15f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)((StackEntryBuilder)LootProvider.item(Items.REDSTONE, 2, 10).setWeight(60)).setQuality(1)).apply((LootItemFunction.Builder)this.fortuneBonus(0.2f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)((StackEntryBuilder)LootProvider.item(Items.LAPIS_LAZULI, 5, 15).setWeight(60)).setQuality(2)).apply((LootItemFunction.Builder)this.fortuneBonus(0.2f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.DIAMOND, 1, 3).setWeight(60)).setQuality(3)).apply(this.fortuneBonus(0.1f))).withPool(LootPool.lootPool().when(this.hasSilkTouch()).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)0.02f)).add((LootPoolEntryContainer.Builder)LootProvider.item(Items.DEEPSLATE_IRON_ORE, 1, 3).setWeight(80)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.DEEPSLATE_GOLD_ORE, 1, 3).setWeight(100)).setQuality(1)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.DEEPSLATE_REDSTONE_ORE, 2, 5).setWeight(60)).setQuality(1)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.DEEPSLATE_LAPIS_ORE, 3, 8).setWeight(60)).setQuality(2)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.DEEPSLATE_DIAMOND_ORE, 1, 2).setWeight(60)).setQuality(3))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setY(MinMaxBounds.Doubles.atMost((double)-48.0))).and(this.doesNotHaveSilkTouch())).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.REDSTONE, 2, 10).setWeight(15)).apply((LootItemFunction.Builder)this.fortuneBonus(0.1f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.DIAMOND, 1, 3).setWeight(15)).apply((LootItemFunction.Builder)this.fortuneBonus(0.08f))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(70))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setY(MinMaxBounds.Doubles.atMost((double)-48.0))).and(this.hasSilkTouch())).add((LootPoolEntryContainer.Builder)LootProvider.item(Items.DEEPSLATE_REDSTONE_ORE, 2, 4).setWeight(15)).add((LootPoolEntryContainer.Builder)LootProvider.item(Items.DEEPSLATE_DIAMOND_ORE, 1, 2).setWeight(15)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(70))));
            output.accept(Ench.LootTables.BOON_NETHER_DROPS, LootTable.lootTable().withPool(LootPool.lootPool().when(this.doesNotHaveSilkTouch()).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)0.02f)).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.QUARTZ, 3, 5).setWeight(150)).apply((LootItemFunction.Builder)this.fortuneBonus(0.15f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.RAW_GOLD, 1, 5).setWeight(100)).apply((LootItemFunction.Builder)this.fortuneBonus(0.1f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.GLOWSTONE_DUST, 2, 10).setWeight(60)).apply((LootItemFunction.Builder)this.fortuneBonus(0.15f))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.ANCIENT_DEBRIS, 0, 1).setWeight(1)).apply((LootItemFunction.Builder)this.fortuneBonus(0.03f)))).withPool(LootPool.lootPool().when(this.hasSilkTouch()).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)0.02f)).add((LootPoolEntryContainer.Builder)LootProvider.item(Items.NETHER_QUARTZ_ORE, 2, 4).setWeight(150)).add((LootPoolEntryContainer.Builder)LootProvider.item(Items.NETHER_GOLD_ORE, 1, 3).setWeight(100)).add((LootPoolEntryContainer.Builder)LootProvider.item(Items.GLOWSTONE, 1, 3).setWeight(60)).add((LootPoolEntryContainer.Builder)LootProvider.item(Items.ANCIENT_DEBRIS, 0, 1).setWeight(1))).withPool(LootPool.lootPool().when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setY(MinMaxBounds.Doubles.between((double)12.0, (double)18.0)))).add((LootPoolEntryContainer.Builder)((StackEntryBuilder)LootProvider.item(Items.ANCIENT_DEBRIS, 1, 1).setWeight(3)).apply((LootItemFunction.Builder)this.fortuneBonus(0.03f))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(97))));
        }

        protected LootItemCondition.Builder hasSilkTouch() {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
        }

        protected LootItemCondition.Builder doesNotHaveSilkTouch() {
            return this.hasSilkTouch().invert();
        }

        protected LootItemConditionalFunction.Builder<?> fortuneBonus(float probability) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)probability, (int)0);
        }
    }

    public static class BlockLoot
    extends BlockLootSubProvider {
        public static final Set<Item> EXPLOSION_RESISTANT = Set.of();

        protected BlockLoot(HolderLookup.Provider registries) {
            super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), registries);
        }

        protected void generate() {
            this.dropSelf(Ench.Blocks.HELLSHELF);
            this.dropSelf(Ench.Blocks.INFUSED_HELLSHELF);
            this.dropSelf(Ench.Blocks.BLAZING_HELLSHELF);
            this.dropSelf(Ench.Blocks.GLOWING_HELLSHELF);
            this.dropSelf(Ench.Blocks.SEASHELF);
            this.dropSelf(Ench.Blocks.INFUSED_SEASHELF);
            this.dropSelf(Ench.Blocks.CRYSTAL_SEASHELF);
            this.dropSelf(Ench.Blocks.HEART_SEASHELF);
            this.dropSelf(Ench.Blocks.DORMANT_DEEPSHELF);
            this.dropSelf(Ench.Blocks.DEEPSHELF);
            this.dropSelf(Ench.Blocks.ECHOING_DEEPSHELF);
            this.dropSelf(Ench.Blocks.SOUL_TOUCHED_DEEPSHELF);
            this.dropSelf(Ench.Blocks.ECHOING_SCULKSHELF);
            this.dropSelf(Ench.Blocks.SOUL_TOUCHED_SCULKSHELF);
            this.dropSelf(Ench.Blocks.ENDSHELF);
            this.dropSelf(Ench.Blocks.PEARL_ENDSHELF);
            this.dropSelf(Ench.Blocks.DRACONIC_ENDSHELF);
            this.dropSelf(Ench.Blocks.BEESHELF);
            this.dropSelf(Ench.Blocks.MELONSHELF);
            this.dropSelf(Ench.Blocks.STONESHELF);
            this.dropSelf(Ench.Blocks.LIBRARY);
            this.dropSelf(Ench.Blocks.GEODE_SHELF);
            this.dropSelf(Ench.Blocks.SIGHTSHELF);
            this.dropSelf(Ench.Blocks.SIGHTSHELF_T2);
            this.dropSelf(Ench.Blocks.ENDER_LIBRARY);
            this.dropSelf(Ench.Blocks.FILTERING_SHELF);
            this.dropSelf(Ench.Blocks.TREASURE_SHELF);
        }

        protected Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.BLOCK.holders().filter(h -> h.getKey().location().getNamespace().equals("apothic_enchanting")).map(Holder::value).toList();
        }

        protected void dropSelf(Holder<Block> block) {
            this.dropSelf((Block)block.value());
        }
    }
}

