/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class EnchantedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, ItemStack stack, int level, float eterna, float quanta, float arcana, boolean stable) {
        this.trigger(player, inst -> inst.test(stack, level, eterna, quanta, arcana, stable));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, MinMaxBounds.Ints levels, MinMaxBounds.Doubles eterna, MinMaxBounds.Doubles quanta, MinMaxBounds.Doubles arcana, Optional<Boolean> stable) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(TriggerInstance::item), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("levels", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::levels), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("eterna", (Object)MinMaxBounds.Doubles.ANY).forGetter(TriggerInstance::eterna), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("quanta", (Object)MinMaxBounds.Doubles.ANY).forGetter(TriggerInstance::quanta), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("arcana", (Object)MinMaxBounds.Doubles.ANY).forGetter(TriggerInstance::arcana), (App)Codec.BOOL.optionalFieldOf("stable").forGetter(TriggerInstance::stable)).apply((Applicative)inst, TriggerInstance::new));

        public boolean test(ItemStack stack, int level, float eterna, float quanta, float arcana, boolean stable) {
            return !(!this.item.isEmpty() && !this.item.get().test(stack) || !this.levels.matches(level) || !this.eterna.matches((double)eterna) || !this.quanta.matches((double)quanta) || !this.arcana.matches((double)arcana) || !this.stable.isEmpty() && this.stable.get() != stable);
        }
    }
}

