/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.EnchantmentInfo;
import dev.shadowsoffire.apothic_enchanting.api.EnchantableItem;
import dev.shadowsoffire.apothic_enchanting.table.Arcana;
import dev.shadowsoffire.apothic_enchanting.table.EnchantmentTableStats;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.storage.loot.LootContext;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class ApothEnchantmentHelper {
    public static int getEnchantmentCost(RandomSource rand, int num, float eterna, ItemStack stack) {
        int level = Math.round(eterna);
        if (num == 2) {
            return level;
        }
        float lowBound = 0.6f - 0.4f * (float)(1 - num);
        float highBound = 0.8f - 0.4f * (float)(1 - num);
        return Math.max(1, Math.round((float)level * Mth.nextFloat((RandomSource)rand, (float)lowBound, (float)highBound)));
    }

    public static Stream<Holder<Enchantment>> getPossibleEnchantments(HolderLookup.RegistryLookup<Enchantment> reg, ItemStack stack, EnchantmentTableStats stats) {
        ItemEnchantments enchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        return reg.listElements().filter(h -> h.is(EnchantmentTags.IN_ENCHANTING_TABLE) || stats.treasure() && h.is(EnchantmentTags.TREASURE)).filter(h -> !stats.blacklist().contains(h)).filter(h -> !enchants.keySet().contains(h)).map(Function.identity());
    }

    public static List<EnchantmentInstance> selectEnchantment(RandomSource rand, ItemStack stack, int level, EnchantmentTableStats stats, HolderLookup.RegistryLookup<Enchantment> reg) {
        ArrayList<EnchantmentInstance> chosenEnchants = new ArrayList<EnchantmentInstance>();
        int enchantability = stack.getEnchantmentValue();
        if (enchantability > 0) {
            float quantaFactor = ApothEnchantmentHelper.getQuantaFactor(rand, stats.quanta(), stats.stable());
            int power = Mth.clamp((int)Math.round((float)level * quantaFactor), (int)1, (int)200);
            Arcana arcanaVals = Arcana.getForThreshold(stats.arcana());
            Stream<Holder<Enchantment>> possible = ApothEnchantmentHelper.getPossibleEnchantments(reg, stack, stats);
            List<EnchantmentInstance> allEnchants = ApothEnchantmentHelper.getAvailableEnchantmentResults(power, stack, possible);
            List<ArcanaEnchantmentData> possibleEnchants = allEnchants.stream().map(d -> new ArcanaEnchantmentData(arcanaVals, (EnchantmentInstance)d)).collect(Collectors.toList());
            for (int i = 0; i < 100; i += 33) {
                if (!(stats.arcana() >= (float)i) || possibleEnchants.size() <= 0) continue;
                ApothEnchantmentHelper.pickEnchantment(rand, chosenEnchants, possibleEnchants);
            }
            int randomBound = Math.max(50, (int)((float)level * 1.15f));
            while (rand.nextInt(randomBound) <= level && !possibleEnchants.isEmpty()) {
                ApothEnchantmentHelper.pickEnchantment(rand, chosenEnchants, possibleEnchants);
                level /= 2;
            }
        }
        return ((EnchantableItem)stack.getItem()).selectEnchantments(chosenEnchants, rand, stack, level, stats);
    }

    public static void pickEnchantment(RandomSource rand, List<EnchantmentInstance> chosenEnchants, List<ArcanaEnchantmentData> possibleEnchants) {
        chosenEnchants.add(((ArcanaEnchantmentData)((Object)WeightedRandom.getRandomItem((RandomSource)rand, possibleEnchants).get())).data);
        ApothEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentInstance)Util.lastOf(chosenEnchants));
    }

    public static void removeIncompatible(List<ArcanaEnchantmentData> possibleEnchants, EnchantmentInstance data) {
        Iterator<ArcanaEnchantmentData> iterator = possibleEnchants.iterator();
        while (iterator.hasNext()) {
            if (Enchantment.areCompatible((Holder)data.enchantment, (Holder)iterator.next().data.enchantment)) continue;
            iterator.remove();
        }
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(int level, ItemStack stack, Stream<Holder<Enchantment>> possibleEnchantments) {
        ArrayList selected = Lists.newArrayList();
        possibleEnchantments.filter(arg_0 -> ((ItemStack)stack).isPrimaryItemFor(arg_0)).forEach(ench -> {
            EnchantmentInfo info = ApothicEnchanting.getEnchInfo((Holder<Enchantment>)ench);
            for (int i = info.getMaxLevel(); i >= ((Enchantment)ench.value()).getMinLevel(); --i) {
                if (level < info.getMinPower(i) || level > info.getMaxPower(i)) continue;
                selected.add(new EnchantmentInstance(ench, i));
                break;
            }
        });
        return selected;
    }

    public static float getQuantaFactor(RandomSource rand, float quanta, boolean isStable) {
        if (isStable) {
            return 1.0f + quanta * rand.nextFloat() / 100.0f;
        }
        float gaussian = (float)rand.nextGaussian();
        float factor = Mth.clamp((float)(gaussian / 3.0f), (float)-1.0f, (float)1.0f);
        return 1.0f + quanta * factor / 100.0f;
    }

    @Nullable
    public static <T> Pair<T, Integer> getHighestEquippedLevel(DataComponentType<T> effectComp, LivingEntity entity) {
        MutableObject result = new MutableObject();
        EnchantmentHelper.runIterationOnEquipment((LivingEntity)entity, (ench, level, slot) -> {
            Object data = ((Enchantment)ench.value()).effects().get(effectComp);
            if (data != null && (result.getValue() == null || (Integer)((Pair)result.getValue()).getSecond() < level)) {
                result.setValue((Object)Pair.of((Object)data, (Object)level));
            }
        });
        return (Pair)result.getValue();
    }

    public static float processValue(List<ConditionalEffect<EnchantmentValueEffect>> effects, LootContext ctx, int level, float initial) {
        MutableFloat f = new MutableFloat(initial);
        Enchantment.applyEffects(effects, (LootContext)ctx, valueEffect -> f.setValue(valueEffect.process(level, ctx.getRandom(), f.getValue().floatValue())));
        return f.getValue().floatValue();
    }

    public static float processValue(List<EnchantmentValueEffect> effects, RandomSource rand, int level, float initial) {
        MutableFloat f = new MutableFloat(initial);
        effects.forEach(valueEffect -> f.setValue(valueEffect.process(level, rand, f.getValue().floatValue())));
        return f.getValue().floatValue();
    }

    public static class ArcanaEnchantmentData
    extends WeightedEntry.IntrusiveBase {
        EnchantmentInstance data;

        public ArcanaEnchantmentData(Arcana arcana, EnchantmentInstance data) {
            super(arcana.adjustWeight(((Enchantment)data.enchantment.value()).getWeight()));
            this.data = data;
        }
    }
}

