/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.mob_effect;

import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class DetonationEffect
extends MobEffect {
    public DetonationEffect() {
        super(MobEffectCategory.HARMFUL, 16766976);
    }

    public boolean applyEffectTick(LivingEntity entity, int amp) {
        int ticks = entity.getRemainingFireTicks();
        if (ticks > 0) {
            entity.setRemainingFireTicks(0);
            entity.hurt(entity.level().damageSources().source(ALObjects.DamageTypes.BLEEDING), (float)((1 + amp) * ticks) / 14.0f);
            ServerLevel level = (ServerLevel)entity.level();
            AABB bb = entity.getBoundingBox();
            level.sendParticles((ParticleOptions)ParticleTypes.FLAME, entity.getX(), entity.getY(), entity.getZ(), 100, bb.getXsize(), bb.getYsize(), bb.getZsize(), 0.25);
            level.playSound(null, (Entity)entity, SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.HOSTILE, 1.0f, 1.2f);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amp) {
        return duration == 1;
    }
}

