/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes;

import dev.shadowsoffire.apothic_attributes.ALConfig;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.client.AttributesLibClient;
import dev.shadowsoffire.apothic_attributes.compat.CuriosCompat;
import dev.shadowsoffire.apothic_attributes.impl.AttributeEvents;
import dev.shadowsoffire.apothic_attributes.payload.ConfigPayload;
import dev.shadowsoffire.apothic_attributes.payload.CritParticlePayload;
import dev.shadowsoffire.apothic_attributes.util.MiscDatagen;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.registry.DeferredHelper;
import java.io.File;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="apothic_attributes")
public class ApothicAttributes {
    public static final String MODID = "apothic_attributes";
    public static final Logger LOGGER = LogManager.getLogger((String)"apothic_attributes");
    public static final DeferredHelper R = DeferredHelper.create((String)"apothic_attributes");
    public static final boolean DEBUG_AUX_DMG = "on".equalsIgnoreCase(System.getenv("APOTH_DEBUG_AUX_DMG"));
    private static final File configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "apotheosis");
    private static float localAtkStrength = 1.0f;

    public ApothicAttributes(IEventBus bus) {
        bus.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new AttributeEvents());
        NeoForge.EVENT_BUS.addListener(ApothicAttributes::trackCooldown);
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.register((Object)new AttributesLibClient());
            bus.register(AttributesLibClient.ModBusSub.class);
        }
        PayloadHelper.registerPayload((PayloadProvider)new CritParticlePayload.Provider());
        ALObjects.bootstrap(bus);
        NeoForgeMod.enableMergedAttributeTooltips();
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            ALConfig.load();
            ((MobEffect)MobEffects.BLINDNESS.value()).addAttributeModifier(Attributes.FOLLOW_RANGE, ApothicAttributes.loc("blindness"), -0.75, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        });
        PayloadHelper.registerPayload((PayloadProvider)new ConfigPayload.Provider());
    }

    @SubscribeEvent
    public void applyAttribs(EntityAttributeModificationEvent e) {
        e.getTypes().forEach(type -> ApothicAttributes.addAll((EntityType<? extends LivingEntity>)type, (arg_0, arg_1) -> ((EntityAttributeModificationEvent)e).add(arg_0, arg_1), ALObjects.Attributes.DRAW_SPEED, ALObjects.Attributes.CRIT_CHANCE, ALObjects.Attributes.CRIT_DAMAGE, ALObjects.Attributes.COLD_DAMAGE, ALObjects.Attributes.FIRE_DAMAGE, ALObjects.Attributes.LIFE_STEAL, ALObjects.Attributes.CURRENT_HP_DAMAGE, ALObjects.Attributes.OVERHEAL, ALObjects.Attributes.GHOST_HEALTH, ALObjects.Attributes.MINING_SPEED, ALObjects.Attributes.ARROW_DAMAGE, ALObjects.Attributes.ARROW_VELOCITY, ALObjects.Attributes.EXPERIENCE_GAINED, ALObjects.Attributes.HEALING_RECEIVED, ALObjects.Attributes.ARMOR_PIERCE, ALObjects.Attributes.ARMOR_SHRED, ALObjects.Attributes.PROJECTILE_DAMAGE, ALObjects.Attributes.PROT_PIERCE, ALObjects.Attributes.PROT_SHRED, ALObjects.Attributes.DODGE_CHANCE, ALObjects.Attributes.ELYTRA_FLIGHT));
    }

    @SafeVarargs
    private static void addAll(EntityType<? extends LivingEntity> type, BiConsumer<EntityType<? extends LivingEntity>, Holder<Attribute>> add, Holder<Attribute> ... attribs) {
        for (Holder<Attribute> a : attribs) {
            add.accept(type, a);
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        AttributeSupplier playerAttribs = DefaultAttributes.getSupplier((EntityType)EntityType.PLAYER);
        BuiltInRegistries.ATTRIBUTE.holders().forEach(attr -> {
            if (playerAttribs.hasAttribute((Holder)attr)) {
                ((Attribute)attr.value()).setSyncable(true);
            }
        });
        if (ModList.get().isLoaded("curios")) {
            e.enqueueWork(CuriosCompat::init);
        }
    }

    @SubscribeEvent
    public void data(GatherDataEvent e) {
        MiscDatagen gen = new MiscDatagen(e.getGenerator().getPackOutput().getOutputFolder(PackOutput.Target.DATA_PACK).resolve(MODID), e.getLookupProvider());
        e.getGenerator().addProvider(true, (DataProvider)gen);
    }

    public static File getConfigFile(String path) {
        return new File(configDir, path + ".cfg");
    }

    public static float getLocalAtkStrength(Entity entity) {
        if (entity instanceof Player) {
            return localAtkStrength;
        }
        return 1.0f;
    }

    public static TooltipFlag getTooltipFlag() {
        if (FMLEnvironment.dist.isClient()) {
            return ClientAccess.getTooltipFlag();
        }
        return TooltipFlag.NORMAL;
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static MutableComponent lang(String type, String path, Object ... args) {
        return Component.translatable((String)ApothicAttributes.langKey(type, path), (Object[])args);
    }

    public static String langKey(String type, String path) {
        return type + ".apothic_attributes." + path;
    }

    private static void trackCooldown(AttackEntityEvent e) {
        Player p = e.getEntity();
        localAtkStrength = p.getAttackStrengthScale(0.5f);
    }

    private static class ClientAccess {
        private ClientAccess() {
        }

        static TooltipFlag getTooltipFlag() {
            return Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        }
    }
}

