/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.event.CanSocketGemEvent;
import dev.shadowsoffire.apotheosis.event.GetItemSocketsEvent;
import dev.shadowsoffire.apotheosis.event.ItemSocketingEvent;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.socket.SocketedGems;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.UnsocketedGem;
import dev.shadowsoffire.placebo.util.CachedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class SocketHelper {
    public static final ResourceLocation GEMS_CACHED_OBJECT = Apotheosis.loc("gems");
    private static final ToIntFunction<ItemStack> SOCKET_DEPENDENT_COMPONENTS_HASHER = CachedObject.hashComponents((DataComponentType[])new DataComponentType[]{Apoth.Components.GEM, Apoth.Components.PURITY, Apoth.Components.SOCKETED_GEMS});

    public static int getSockets(ItemStack stack) {
        int sockets = (Integer)stack.getOrDefault(Apoth.Components.SOCKETS, (Object)0);
        GetItemSocketsEvent event = new GetItemSocketsEvent(stack, sockets);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getSockets();
    }

    public static void setSockets(ItemStack stack, int sockets) {
        stack.set(Apoth.Components.SOCKETS, (Object)Mth.clamp((int)sockets, (int)0, (int)16));
    }

    public static SocketedGems getGems(ItemStack stack) {
        return (SocketedGems)CachedObject.CachedObjectSource.getOrCreate((ItemStack)stack, (ResourceLocation)GEMS_CACHED_OBJECT, SocketHelper::getGemsImpl, SocketHelper::hashSockets);
    }

    private static int hashSockets(ItemStack stack) {
        return Objects.hash(SOCKET_DEPENDENT_COMPONENTS_HASHER.applyAsInt(stack), SocketHelper.getSockets(stack));
    }

    private static SocketedGems getGemsImpl(ItemStack stack) {
        int size = SocketHelper.getSockets(stack);
        if (size <= 0 || stack.isEmpty()) {
            return SocketedGems.EMPTY;
        }
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            return SocketedGems.EMPTY;
        }
        NonNullList list = NonNullList.withSize((int)size, (Object)GemInstance.EMPTY);
        ItemContainerContents socketedGems = (ItemContainerContents)stack.getOrDefault(Apoth.Components.SOCKETED_GEMS, (Object)ItemContainerContents.EMPTY);
        for (int i = 0; i < Math.min(size, socketedGems.getSlots()); ++i) {
            ItemStack gem = socketedGems.getStackInSlot(i);
            if (gem.isEmpty()) continue;
            gem.setCount(1);
            GemInstance inst = GemInstance.socketed(stack, gem, i);
            list.set(i, (Object)inst);
        }
        return new SocketedGems((List<GemInstance>)list);
    }

    public static void setGems(ItemStack stack, SocketedGems gems) {
        ItemContainerContents contents = ItemContainerContents.fromItems(gems.stream().map(GemInstance::gemStack).toList());
        stack.set(Apoth.Components.SOCKETED_GEMS, (Object)contents);
    }

    public static boolean hasEmptySockets(ItemStack stack) {
        return SocketHelper.getGems(stack).gems().stream().anyMatch(g -> !g.isValid());
    }

    public static int getFirstEmptySocket(ItemStack stack) {
        SocketedGems gems = SocketHelper.getGems(stack);
        for (int socket = 0; socket < gems.size(); ++socket) {
            if (gems.get(socket).isValid()) continue;
            return socket;
        }
        return 0;
    }

    public static boolean canSocketGemInItem(ItemStack stack, ItemStack gemStack) {
        UnsocketedGem gem = UnsocketedGem.of(gemStack);
        if (!gem.isValid() || !SocketHelper.hasEmptySockets(stack)) {
            return false;
        }
        CanSocketGemEvent event = (CanSocketGemEvent)NeoForge.EVENT_BUS.post((Event)new CanSocketGemEvent(stack, gemStack));
        return !event.isCanceled() && gem.canApplyTo(stack);
    }

    public static ItemStack socketGemInItem(ItemStack stack, ItemStack gemStack) {
        if (!SocketHelper.canSocketGemInItem(stack, gemStack)) {
            return ItemStack.EMPTY;
        }
        ItemStack result = stack.copy();
        result.setCount(1);
        int socket = SocketHelper.getFirstEmptySocket(result);
        ArrayList<GemInstance> gems = new ArrayList<GemInstance>((Collection<GemInstance>)SocketHelper.getGems(result).gems());
        ItemStack gemToInsert = gemStack.copy();
        gemToInsert.setCount(1);
        gems.set(socket, GemInstance.socketed(result, gemStack.copy(), socket));
        SocketHelper.setGems(result, new SocketedGems(gems));
        ItemSocketingEvent event = (ItemSocketingEvent)NeoForge.EVENT_BUS.post((Event)new ItemSocketingEvent(stack, gemToInsert, result));
        return event.getOutput();
    }

    public static Stream<GemInstance> getGemInstances(Projectile proj) {
        ItemStack stack = AffixHelper.getSourceWeapon((Entity)proj);
        return SocketHelper.getGems(stack).stream().filter(GemInstance::isValid);
    }
}

