/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.LootRule;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.Unbreakable;

public class RarityProvider
extends DynamicRegistryProvider<LootRarity> {
    public RarityProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)RarityRegistry.INSTANCE);
    }

    public String getName() {
        return "Rarities";
    }

    public void generate() {
        this.addRarity("common", TextColor.fromRgb((int)0x808080), Apoth.Items.COMMON_MATERIAL, b -> b.sortIndex(300).weights(TieredWeights.builder().with(WorldTier.HAVEN, 600, 0.0f).with(WorldTier.FRONTIER, 290, 0.0f).with(WorldTier.ASCENT, 100, 0.0f).with(WorldTier.SUMMIT, 0, 0.0f).with(WorldTier.PINNACLE, 0, 0.0f)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.ChancedLootRule(0.25f, new LootRule.AffixLootRule(AffixType.STAT))).renderData(c -> c.beamHeight(0.0f)));
        this.addRarity("uncommon", TextColor.fromRgb((int)0x33FF33), Apoth.Items.UNCOMMON_MATERIAL, b -> b.sortIndex(400).weights(TieredWeights.builder().with(WorldTier.HAVEN, 360, 2.5f).with(WorldTier.FRONTIER, 600, 0.0f).with(WorldTier.ASCENT, 300, 0.0f).with(WorldTier.SUMMIT, 120, 0.0f).with(WorldTier.PINNACLE, 0, 0.0f)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.ChancedLootRule(0.5f, new LootRule.AffixLootRule(AffixType.BASIC_EFFECT))).rule(new LootRule.SocketLootRule(0, 1)).renderData(c -> c.beamHeight(0.0f).shadow(d -> d.alpha(175).texture(Apotheosis.loc("textures/rarity/shadow_t1.png")).frames(20).frameTime(1.5f))));
        this.addRarity("rare", TextColor.fromRgb((int)0x5555FF), Apoth.Items.RARE_MATERIAL, b -> b.sortIndex(500).weights(TieredWeights.builder().with(WorldTier.HAVEN, 40, 5.0f).with(WorldTier.FRONTIER, 100, 5.0f).with(WorldTier.ASCENT, 500, 2.5f).with(WorldTier.SUMMIT, 290, 2.5f).with(WorldTier.PINNACLE, 100, 0.0f)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule(new LootRule.ChancedLootRule(0.35f, new LootRule.AffixLootRule(AffixType.BASIC_EFFECT))).rule(new LootRule.SocketLootRule(0, 2)).rule(new LootRule.DurabilityLootRule(0.1f, 0.25f)).renderData(c -> c.beamHeight(2.5f).glowRadius(0.0f).shadow(d -> d.texture(Apotheosis.loc("textures/rarity/shadow_t2.png")).frames(20).frameTime(1.5f))));
        this.addRarity("epic", TextColor.fromRgb((int)0xBB00BB), Apoth.Items.EPIC_MATERIAL, b -> b.sortIndex(600).weights(TieredWeights.builder().with(WorldTier.HAVEN, 0, 0.0f).with(WorldTier.FRONTIER, 10, 0.0f).with(WorldTier.ASCENT, 100, 5.0f).with(WorldTier.SUMMIT, 540, 5.0f).with(WorldTier.PINNACLE, 650, 2.5f)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule(new LootRule.ChancedLootRule(0.25f, new LootRule.AffixLootRule(AffixType.BASIC_EFFECT))).rule(new LootRule.AffixLootRule(AffixType.ABILITY)).rule(new LootRule.SocketLootRule(1, 3)).rule(new LootRule.DurabilityLootRule(0.25f, 0.55f)).renderData(c -> c.beamHeight(3.0f).shadow(d -> d.texture(Apotheosis.loc("textures/rarity/shadow_t3.png")).frames(20).size(0.4f).frameTime(1.5f)).particle(true)));
        this.addRarity("mythic", TextColor.fromRgb((int)15560724), Apoth.Items.MYTHIC_MATERIAL, b -> b.sortIndex(700).weights(TieredWeights.builder().with(WorldTier.HAVEN, 0, 0.0f).with(WorldTier.FRONTIER, 0, 0.0f).with(WorldTier.ASCENT, 0, 0.0f).with(WorldTier.SUMMIT, 50, 5.0f).with(WorldTier.PINNACLE, 250, 10.0f)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule(new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule(new LootRule.AffixLootRule(AffixType.ABILITY)).rule(new LootRule.SelectLootRule(0.95f, new LootRule.SocketLootRule(1, 3), new LootRule.SocketLootRule(4, 4))).rule(new LootRule.SelectLootRule(0.99f, new LootRule.DurabilityLootRule(0.45f, 0.75f), new LootRule.ComponentLootRule(DataComponentPatch.builder().set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).remove(Apoth.Components.DURABILITY_BONUS).build()))).renderData(c -> c.shadow(d -> d.texture(Apotheosis.loc("textures/rarity/shadow_t4.png")).frames(7).size(0.4f).frameTime(1.5f)).particle(true)));
    }

    static <T> LootRule componentRule(DataComponentType<T> type, T value) {
        return new LootRule.ComponentLootRule(DataComponentPatch.builder().set(type, value).build());
    }

    void addRarity(String id, TextColor color, Holder<Item> material, UnaryOperator<LootRarity.Builder> config) {
        this.add(Apotheosis.loc(id), ((LootRarity.Builder)config.apply(RarityProvider.builder(color, material))).build());
    }

    public static LootRarity.Builder builder(TextColor color, Holder<Item> material) {
        return new LootRarity.Builder(color, material);
    }
}

