/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.LootRule;
import dev.shadowsoffire.apotheosis.loot.RarityOverride;
import dev.shadowsoffire.apotheosis.loot.RarityOverrideRegistry;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.component.Unbreakable;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class RarityOverrideProvider
extends DynamicRegistryProvider<RarityOverride> {
    public RarityOverrideProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)RarityOverrideRegistry.INSTANCE);
    }

    public String getName() {
        return "rarity_overrides";
    }

    public void generate() {
        LootRarity common = RarityOverrideProvider.rarity("common");
        LootRarity uncommon = RarityOverrideProvider.rarity("uncommon");
        LootRarity rare = RarityOverrideProvider.rarity("rare");
        LootRarity epic = RarityOverrideProvider.rarity("epic");
        LootRarity mythic = RarityOverrideProvider.rarity("mythic");
        this.addOverride(Apoth.LootCategories.SHEARS, b -> b.override(common, c -> c.rule(new LootRule.SocketLootRule(0, 1)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.DurabilityLootRule(0.05f, 0.1f))).override(uncommon, c -> c.rule(new LootRule.SocketLootRule(1, 1)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.DurabilityLootRule(0.1f, 0.15f))).override(rare, c -> c.rule(new LootRule.SocketLootRule(1, 1)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule(new LootRule.DurabilityLootRule(0.1f, 0.25f))).override(epic, c -> c.rule(new LootRule.SocketLootRule(1, 1)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule(new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule(new LootRule.DurabilityLootRule(0.25f, 0.55f))).override(mythic, c -> c.rule(new LootRule.SocketLootRule(1, 2)).rule(new LootRule.AffixLootRule(AffixType.STAT)).rule(new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule(new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule(new LootRule.SelectLootRule(0.99f, new LootRule.DurabilityLootRule(0.45f, 0.75f), new LootRule.ComponentLootRule(DataComponentPatch.builder().set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).remove(Apoth.Components.DURABILITY_BONUS).build())))));
    }

    private static LootRarity rarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(Apotheosis.loc(path))));
    }

    private void addOverride(LootCategory category, UnaryOperator<RarityOverride.Builder> config) {
        this.add(Apotheosis.loc(Apoth.BuiltInRegs.LOOT_CATEGORY.getKey((Object)category).toString().replace(':', '/')), ((RarityOverride.Builder)config.apply(RarityOverride.builder(category))).build());
    }
}

