/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.PurityWeightsRegistry;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;

public class PurityWeightsProvider
extends DynamicRegistryProvider<PurityWeightsRegistry.PurityWeights> {
    public PurityWeightsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)PurityWeightsRegistry.INSTANCE);
    }

    public String getName() {
        return "Purity Weights";
    }

    public void generate() {
        this.add(b -> b.tier(WorldTier.HAVEN, c -> c.with(Purity.CRACKED, 550, 0.0f).with(Purity.CHIPPED, 410, 2.5f).with(Purity.FLAWED, 40, 5.0f).with(Purity.NORMAL, 0, 0.0f).with(Purity.FLAWLESS, 0, 0.0f).with(Purity.PERFECT, 0, 0.0f)).tier(WorldTier.FRONTIER, c -> c.with(Purity.CRACKED, 230, 0.0f).with(Purity.CHIPPED, 540, 0.0f).with(Purity.FLAWED, 180, 2.5f).with(Purity.NORMAL, 50, 1.0f).with(Purity.FLAWLESS, 0, 0.0f).with(Purity.PERFECT, 0, 0.0f)).tier(WorldTier.ASCENT, c -> c.with(Purity.CRACKED, 20, 0.0f).with(Purity.CHIPPED, 250, 0.0f).with(Purity.FLAWED, 560, 2.5f).with(Purity.NORMAL, 160, 5.0f).with(Purity.FLAWLESS, 10, 1.0f).with(Purity.PERFECT, 0, 0.0f)).tier(WorldTier.SUMMIT, c -> c.with(Purity.CRACKED, 0, 0.0f).with(Purity.CHIPPED, 80, 0.0f).with(Purity.FLAWED, 310, 2.5f).with(Purity.NORMAL, 580, 5.0f).with(Purity.FLAWLESS, 20, 5.0f).with(Purity.PERFECT, 10, 0.0f)).tier(WorldTier.PINNACLE, c -> c.with(Purity.CRACKED, 0, 0.0f).with(Purity.CHIPPED, 0, 0.0f).with(Purity.FLAWED, 100, 0.0f).with(Purity.NORMAL, 330, 0.0f).with(Purity.FLAWLESS, 470, 0.0f).with(Purity.PERFECT, 100, 5.0f)));
    }

    private void add(UnaryOperator<Builder> config) {
        this.add(PurityWeightsRegistry.TARGET_FILE, ((Builder)config.apply(new Builder())).build());
    }

    private static class Builder {
        Map<WorldTier, Map<Purity, TieredWeights.Weight>> weightsMap = new HashMap<WorldTier, Map<Purity, TieredWeights.Weight>>();

        private Builder() {
        }

        public Builder tier(WorldTier tier, UnaryOperator<InnerBuilder> config) {
            this.weightsMap.put(tier, ((InnerBuilder)config.apply(new InnerBuilder())).innerMap);
            return this;
        }

        public PurityWeightsRegistry.PurityWeights build() {
            return new PurityWeightsRegistry.PurityWeights(this.weightsMap);
        }
    }

    private static class InnerBuilder {
        Map<Purity, TieredWeights.Weight> innerMap = new HashMap<Purity, TieredWeights.Weight>();

        private InnerBuilder() {
        }

        InnerBuilder with(Purity purity, int weight, float quality) {
            this.innerMap.put(purity, new TieredWeights.Weight(weight, quality));
            return this;
        }
    }
}

