/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.twilight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.compat.twilight.AdventureTwilightCompat;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class OreMagnetBonus
extends GemBonus {
    public static final Codec<OreMagnetBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(OreMagnetBonus.gemClass(), (App)Purity.mapCodec(Codec.intRange((int)0, (int)4096)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, OreMagnetBonus::new));
    protected final Map<Purity, Integer> values;

    public OreMagnetBonus(GemClass gemClass, Map<Purity, Integer> values) {
        super(gemClass);
        this.values = values;
    }

    @Override
    public InteractionResult onItemUse(GemInstance inst, UseOnContext ctx) {
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        if (state.isAir()) {
            return null;
        }
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        player.startUsingItem(ctx.getHand());
        ((Item)AdventureTwilightCompat.ORE_MAGNET.value()).releaseUsing(inst.gemStack(), level, (LivingEntity)player, 0);
        player.stopUsingItem();
        int cost = this.values.get(inst.purity());
        ctx.getItemInHand().hurtAndBreak(cost, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
        return super.onItemUse(inst, ctx);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    @Override
    public Component getSocketBonusTooltip(GemView gem, AttributeTooltipContext ctx) {
        return Component.translatable((String)("bonus." + String.valueOf(this.getTypeKey()) + ".desc"), (Object[])new Object[]{this.values.get(gem.purity())}).withStyle(ChatFormatting.YELLOW);
    }
}

