/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.jei;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.recipe.SupremacyRecipe;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.LegacyRandomSource;

public class SupremacyExtension
implements ISmithingCategoryExtension<SupremacyRecipe> {
    private static final List<Item> DUMMY_ITEMS = Stream.of(Items.GOLDEN_SWORD, Items.DIAMOND_PICKAXE, Items.STONE_AXE, Items.IRON_CHESTPLATE, Items.BOW).toList();

    public <T extends IIngredientAcceptor<T>> void setTemplate(SupremacyRecipe recipe, T acc) {
    }

    public <T extends IIngredientAcceptor<T>> void setBase(SupremacyRecipe recipe, T acc) {
        List<ItemStack> outputs = this.getDummyItems().toList();
        acc.addItemStacks(outputs);
    }

    public <T extends IIngredientAcceptor<T>> void setAddition(SupremacyRecipe recipe, T acc) {
        acc.addItemStack(new ItemStack(Apoth.Items.SIGIL_OF_SUPREMACY));
    }

    public <T extends IIngredientAcceptor<T>> void setOutput(SupremacyRecipe recipe, T acc) {
        List<ItemStack> outputs = this.getDummyItems().map(stack -> {
            AffixHelper.applySupremacy(stack);
            return stack;
        }).toList();
        acc.addItemStacks(outputs);
    }

    private Stream<ItemStack> getDummyItems() {
        LegacyRandomSource rand = new LegacyRandomSource(0L);
        LootRarity rarity = RarityRegistry.getSortedRarities().getLast();
        return DUMMY_ITEMS.stream().map(ItemStack::new).map(arg_0 -> SupremacyExtension.lambda$getDummyItems$1(rarity, (RandomSource)rand, arg_0));
    }

    private static /* synthetic */ ItemStack lambda$getDummyItems$1(LootRarity rarity, RandomSource rand, ItemStack stack) {
        LootController.createLootItem(stack, rarity, GenContext.dummy(rand));
        AffixHelper.setName(stack, (Component)Apotheosis.lang("text", "any_affix_item", new Object[0]).withStyle(Style.EMPTY.withColor(rarity.color()).withItalic(Boolean.valueOf(false))));
        return stack;
    }
}

