/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.compat.jei.AdventureJEIPlugin;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SalvagingCategory
implements IRecipeCategory<SalvagingRecipe> {
    public static final ResourceLocation TEXTURES = Apotheosis.loc("textures/gui/salvage_jei.png");
    private final Component title = Component.translatable((String)"title.apotheosis.salvaging");
    private final IDrawable background;
    private final IDrawable icon;

    public SalvagingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURES, 0, 0, 98, 74).addPadding(0, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(Apoth.Items.SALVAGING_TABLE));
    }

    public RecipeType<SalvagingRecipe> getRecipeType() {
        return AdventureJEIPlugin.SALVAGING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(SalvagingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gfx, double mouseX, double mouseY) {
        List<SalvagingRecipe.OutputData> outputs = recipe.getOutputs();
        Font font = Minecraft.getInstance().font;
        PoseStack pose = gfx.pose();
        int idx = 0;
        for (SalvagingRecipe.OutputData d : outputs) {
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 200.0f);
            String text = String.format("%d-%d", d.min(), d.max());
            float x = (float)(59 + 18 * (idx % 2)) + (16.0f - (float)font.width(text) * 0.5f);
            float y = 23.0f + (float)(18 * (idx / 2));
            float scale = 0.5f;
            pose.scale(scale, scale, 1.0f);
            gfx.drawString(font, text, (int)(x / scale), (int)(y / scale), 0xFFFFFF);
            ++idx;
            pose.popPose();
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SalvagingRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> input = Arrays.asList(recipe.getInput().getItems());
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 29).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, input);
        List<SalvagingRecipe.OutputData> outputs = recipe.getOutputs();
        int idx = 0;
        for (SalvagingRecipe.OutputData d : outputs) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 59 + 18 * (idx % 2), 11 + 18 * (idx / 2)).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)d.stack());
            ++idx;
        }
    }
}

