/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.jei;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.item.PotionCharmItem;
import dev.shadowsoffire.apotheosis.recipe.PotionCharmRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class PotionCharmExtension
implements ICraftingCategoryExtension<PotionCharmRecipe> {
    public int getWidth(RecipeHolder<PotionCharmRecipe> recipeHolder) {
        return ((PotionCharmRecipe)recipeHolder.value()).getWidth();
    }

    public int getHeight(RecipeHolder<PotionCharmRecipe> recipeHolder) {
        return ((PotionCharmRecipe)recipeHolder.value()).getHeight();
    }

    public void setRecipe(RecipeHolder<PotionCharmRecipe> recipeHolder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        ItemStack focusStack = focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).findFirst().map(IFocus::getTypedValue).map(ITypedIngredient::getIngredient).orElse(ItemStack.EMPTY);
        Holder potion = ((PotionContents)focusStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().orElse(Potions.WATER);
        List recipeInputs = ((PotionCharmRecipe)recipeHolder.value()).getIngredients().stream().map(Ingredient::getItems).map(a -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(((ItemStack[])a).length);
            for (ItemStack s : a) {
                list.add(s.copy());
            }
            return list;
        }).collect(Collectors.toCollection(ArrayList::new));
        if (PotionCharmItem.isValidPotion((Holder<Potion>)potion)) {
            for (List stacks : recipeInputs) {
                if (!((ItemStack)stacks.get(0)).has(DataComponents.POTION_CONTENTS)) continue;
                for (ItemStack s : stacks) {
                    s.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
                }
            }
        } else {
            for (int i = 0; i < recipeInputs.size(); ++i) {
                List stacks = (List)recipeInputs.get(i);
                if (!((ItemStack)stacks.get(0)).has(DataComponents.POTION_CONTENTS)) continue;
                Item mainItem = ((ItemStack)stacks.get(0)).getItem();
                ArrayList potionStacks = new ArrayList();
                BuiltInRegistries.POTION.holders().filter(PotionCharmItem::isValidPotion).forEach(p -> potionStacks.add(PotionContents.createItemStack((Item)mainItem, (Holder)p)));
                recipeInputs.set(i, potionStacks);
            }
        }
        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, recipeInputs, this.getWidth(recipeHolder), this.getHeight(recipeHolder));
        if (PotionCharmItem.isValidPotion((Holder<Potion>)potion)) {
            ItemStack output = PotionContents.createItemStack((Item)((Item)Apoth.Items.POTION_CHARM.value()), (Holder)potion);
            craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(output));
        } else {
            ArrayList potionStacks = new ArrayList();
            BuiltInRegistries.POTION.holders().filter(PotionCharmItem::isValidPotion).forEach(p -> potionStacks.add(PotionContents.createItemStack((Item)((Item)Apoth.Items.POTION_CHARM.value()), (Holder)p)));
            craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, potionStacks);
        }
    }

    public static class PotionCharmSubtypes
    implements ISubtypeInterpreter<ItemStack> {
        public String apply(ItemStack stack, UidContext context) {
            if (context != UidContext.Recipe) {
                if (!PotionCharmItem.hasEffect(stack)) {
                    return "";
                }
                MobEffectInstance contained = PotionCharmItem.getEffect(stack);
                return String.valueOf(contained.getEffect().getKey().location()) + "@" + contained.getAmplifier() + "@" + contained.getDuration();
            }
            return "";
        }

        @Nullable
        public Object getSubtypeData(ItemStack ingredient, UidContext context) {
            String data = this.apply(ingredient, context);
            return data.isEmpty() ? null : data;
        }

        public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
            return this.apply(ingredient, context);
        }
    }
}

