/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.gateways.tiered_gate;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.compat.gateways.tiered_gate.TieredGateClient;
import dev.shadowsoffire.apotheosis.compat.gateways.tiered_gate.TieredGateSettings;
import dev.shadowsoffire.apotheosis.compat.gateways.tiered_gate.TieredGatewayEntity;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.BossEventSettings;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.GateRules;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.SpawnAlgorithms;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record TieredGateway(TieredGateSettings settings, List<Wave> waves, List<Reward> rewards, List<Failure> failures, GateRules rules, BossEventSettings bossSettings) implements Gateway
{
    public static final Codec<TieredGateway> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TieredGateSettings.CODEC.fieldOf("settings").forGetter(TieredGateway::settings), (App)Wave.CODEC.listOf().fieldOf("waves").forGetter(TieredGateway::waves), (App)Reward.CODEC.listOf().optionalFieldOf("rewards", Collections.emptyList()).forGetter(TieredGateway::rewards), (App)Failure.CODEC.listOf().optionalFieldOf("failures", Collections.emptyList()).forGetter(TieredGateway::failures), (App)GateRules.CODEC.optionalFieldOf("rules", (Object)GateRules.DEFAULT).forGetter(TieredGateway::rules), (App)BossEventSettings.CODEC.optionalFieldOf("boss_event", (Object)BossEventSettings.DEFAULT).forGetter(TieredGateway::bossSettings)).apply((Applicative)inst, TieredGateway::new));

    public SpawnAlgorithms.SpawnAlgorithm spawnAlgo() {
        return this.settings.spawnAlgo();
    }

    public TextColor color() {
        return this.settings.color();
    }

    public Gateway.Size size() {
        return this.settings.size();
    }

    @Nullable
    public Component canOpen(Player player) {
        WorldTier tier = WorldTier.getTier(player);
        if (this.settings.tier() != tier) {
            return Apotheosis.lang("error", "gate_tier_incorrect", this.settings.tier().toComponent());
        }
        return null;
    }

    public Holder<SoundEvent> soundtrack() {
        return this.settings.soundtrack();
    }

    public GatewayEntity createEntity(Level level, Player summoner) {
        return new TieredGatewayEntity(level, summoner, (DynamicHolder<Gateway>)GatewayRegistry.INSTANCE.holder((CodecProvider)this));
    }

    public void appendPearlTooltip(Item.TooltipContext ctx, List<Component> tooltips, TooltipFlag flag) {
        TieredGateClient.appendPearlTooltip(this, ctx, tooltips, flag);
    }

    public void renderBossBar(GatewayEntity gate, Object gfx, int x, int y, boolean isInWorld) {
        TieredGateClient.renderBossBar(gate, gfx, x, y, isInWorld);
    }

    public int getNumWaves() {
        return this.waves.size();
    }

    public Wave getWave(int n) {
        return this.waves.get(n);
    }

    public Codec<TieredGateway> getCodec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TieredGateSettings settings = null;
        private final List<Wave> waves = new ArrayList<Wave>();
        private final List<Reward> rewards = new ArrayList<Reward>();
        private final List<Failure> failures = new ArrayList<Failure>();
        private GateRules rules = GateRules.DEFAULT;
        private BossEventSettings bossSettings = BossEventSettings.DEFAULT;

        public Builder settings(UnaryOperator<TieredGateSettings.Builder> config) {
            this.settings = ((TieredGateSettings.Builder)config.apply(new TieredGateSettings.Builder())).build();
            return this;
        }

        public Builder wave(Wave wave) {
            this.waves.add(wave);
            return this;
        }

        public Builder wave(UnaryOperator<Wave.Builder> config) {
            return this.wave(((Wave.Builder)config.apply(new Wave.Builder())).build());
        }

        public Builder waves(List<Wave> waves) {
            this.waves.addAll(waves);
            return this;
        }

        public Builder keyReward(Reward reward) {
            this.rewards.add(reward);
            return this;
        }

        public Builder keyRewards(List<Reward> rewards) {
            this.rewards.addAll(rewards);
            return this;
        }

        public Builder failure(Failure failure) {
            this.failures.add(failure);
            return this;
        }

        public Builder failures(List<Failure> failures) {
            this.failures.addAll(failures);
            return this;
        }

        public Builder rules(GateRules rules) {
            this.rules = rules;
            return this;
        }

        public Builder rules(UnaryOperator<GateRules.Builder> config) {
            return this.rules(((GateRules.Builder)config.apply(GateRules.builder())).build());
        }

        public Builder bossSettings(BossEventSettings bossSettings) {
            this.bossSettings = bossSettings;
            return this;
        }

        public TieredGateway build() {
            Preconditions.checkNotNull((Object)this.settings, (Object)"Settings must be set before building a TieredGateway");
            if (this.waves.isEmpty()) {
                throw new IllegalStateException("Gateway must have at least one wave");
            }
            return new TieredGateway(this.settings, Collections.unmodifiableList(new ArrayList<Wave>(this.waves)), Collections.unmodifiableList(new ArrayList<Reward>(this.rewards)), Collections.unmodifiableList(new ArrayList<Failure>(this.failures)), this.rules, this.bossSettings);
        }
    }
}

