/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.event.enchanting.GetEnchantmentLevelEvent;

public class EnchantmentBonus
extends GemBonus {
    public static Codec<EnchantmentBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(EnchantmentBonus.gemClass(), (App)Enchantment.CODEC.fieldOf("enchantment").forGetter(a -> a.ench), (App)Mode.CODEC.optionalFieldOf("mode", (Object)Mode.SINGLE).forGetter(a -> a.mode), (App)Purity.mapCodec(Codec.intRange((int)1, (int)127)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, EnchantmentBonus::new));
    protected final Holder<Enchantment> ench;
    protected final Mode mode;
    protected final Map<Purity, Integer> values;

    public EnchantmentBonus(GemClass gemClass, Holder<Enchantment> ench, Mode mode, Map<Purity, Integer> values) {
        super(gemClass);
        this.ench = ench;
        this.values = values;
        this.mode = mode;
    }

    @Override
    public Component getSocketBonusTooltip(GemView gem, AttributeTooltipContext ctx) {
        int level = this.values.get(gem.purity());
        String desc = "bonus." + String.valueOf(this.getTypeKey()) + ".desc";
        if (this.mode == Mode.GLOBAL) {
            desc = desc + ".global";
        } else if (this.mode == Mode.EXISTING) {
            desc = desc + ".mustExist";
        }
        MutableComponent enchName = ((Enchantment)this.ench.value()).description().plainCopy();
        return Component.translatable((String)desc, (Object[])new Object[]{level, Component.translatable((String)("misc.apotheosis.level" + (level > 1 ? ".many" : ""))), enchName}).withStyle(ChatFormatting.GREEN);
    }

    @Override
    public void getEnchantmentLevels(GemInstance gem, GetEnchantmentLevelEvent event) {
        ItemEnchantments.Mutable enchantments = event.getEnchantments();
        int level = this.values.get(gem.purity());
        if (this.mode == Mode.GLOBAL) {
            for (Holder e : enchantments.keySet()) {
                int current = enchantments.getLevel(e);
                if (current <= 0) continue;
                enchantments.upgrade(e, current + level);
            }
        } else if (this.mode == Mode.EXISTING) {
            int current = enchantments.getLevel(this.ench);
            if (current > 0) {
                enchantments.upgrade(this.ench, current + level);
            }
        } else {
            enchantments.upgrade(this.ench, enchantments.getLevel(this.ench) + level);
        }
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Mode {
        SINGLE,
        EXISTING,
        GLOBAL;

        public static final Codec<Mode> CODEC;

        static {
            CODEC = PlaceboCodecs.enumCodec(Mode.class);
        }
    }

    public static class Builder
    extends GemBonus.Builder {
        private Holder<Enchantment> enchantment;
        private Mode mode;
        private Map<Purity, Integer> values = new HashMap<Purity, Integer>();

        public Builder() {
            this.mode = Mode.SINGLE;
        }

        public Builder enchantment(Holder<Enchantment> enchantment) {
            this.enchantment = enchantment;
            return this;
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder value(Purity purity, int value) {
            if (value < 1 || value > 127) {
                throw new IllegalArgumentException("EnchantmentBonus is limited to values between 1 and 127 (inclusive).");
            }
            this.values.put(purity, value);
            return this;
        }

        @Override
        public EnchantmentBonus build(GemClass gemClass) {
            return new EnchantmentBonus(gemClass, this.enchantment, this.mode, this.values);
        }
    }
}

