/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot.entry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.loot.entry.ContextualLootPoolEntry;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AffixLootPoolEntry
extends ContextualLootPoolEntry {
    public static final MapCodec<AffixLootPoolEntry> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)PlaceboCodecs.setOf((Codec)RarityRegistry.INSTANCE.holderCodec()).optionalFieldOf("rarities", Set.of()).forGetter(a -> a.rarities), (App)PlaceboCodecs.setOf((Codec)AffixLootRegistry.INSTANCE.holderCodec()).optionalFieldOf("entries", Set.of()).forGetter(a -> a.entries)).and(LootPoolSingletonContainer.singletonFields((RecordCodecBuilder.Instance)inst)).apply((Applicative)inst, AffixLootPoolEntry::new));
    public static final LootPoolEntryType TYPE = new LootPoolEntryType(CODEC);
    private final Set<DynamicHolder<LootRarity>> rarities;
    private final Set<DynamicHolder<AffixLootEntry>> entries;
    private transient boolean validated = false;

    public AffixLootPoolEntry(Set<DynamicHolder<LootRarity>> rarities, Set<DynamicHolder<AffixLootEntry>> entries, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.rarities = rarities;
        this.entries = entries;
    }

    @Override
    protected void createItemStack(Consumer<ItemStack> list, LootContext ctx, GenContext gCtx) {
        ItemStack stack;
        if (!this.validated) {
            this.rarities.forEach(AffixLootPoolEntry::checkBound);
            this.entries.forEach(AffixLootPoolEntry::checkBound);
            this.validated = true;
        }
        if (!(stack = LootController.createAffixItemFromPools(this.rarities, this.entries, gCtx)).isEmpty()) {
            list.accept(stack);
        }
    }

    public LootPoolEntryType getType() {
        return TYPE;
    }

    public static LootPoolSingletonContainer.Builder<?> builder(Set<DynamicHolder<LootRarity>> rarities, Set<DynamicHolder<AffixLootEntry>> entries) {
        return LootPoolSingletonContainer.simpleBuilder((LootPoolSingletonContainer.EntryConstructor)AffixLootPoolEntry.ctor(rarities, entries));
    }

    private static LootPoolSingletonContainer.EntryConstructor ctor(Set<DynamicHolder<LootRarity>> rarities, Set<DynamicHolder<AffixLootEntry>> entries) {
        return (weight, quality, conditions, functions) -> new AffixLootPoolEntry(rarities, entries, weight, quality, conditions, functions);
    }

    private static void checkBound(DynamicHolder<?> holder) {
        if (!holder.isBound()) {
            Apotheosis.LOGGER.error("An AffixLootPoolEntry failed to resolve {}!", (Object)holder.toString());
        }
    }
}

