/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data.twilight;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.data.InvaderProvider;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import twilightforest.init.TFEntities;

public class TwilightInvaderProvider
extends InvaderProvider {
    private static ResourceKey<Level> TWILIGHT_FOREST = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"twilightforest:twilight_forest"));

    public TwilightInvaderProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    @Override
    public String getName() {
        return "Twilight Invaders";
    }

    @Override
    public void generate() {
        LootRarity mythic = TwilightInvaderProvider.rarity("mythic");
        this.addBoss("twilight/carminite_golem", b -> TwilightInvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)((EntityType)TFEntities.CARMINITE_GOLEM.value())).size(2.25, 3.3).basicData(c -> TwilightInvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.SUMMIT, 100, 0.1f)).constraints(Constraints.forDimension(TWILIGHT_FOREST)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)));
        this.addBoss("twilight/goblin_knight", b -> TwilightInvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)((EntityType)TFEntities.LOWER_GOBLIN_KNIGHT.value())).size(1.75, 2.75).basicData(c -> TwilightInvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.ASCENT, 100, 0.1f)).constraints(Constraints.forDimension(TWILIGHT_FOREST)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)));
        this.addBoss("twilight/helmet_crab", b -> b.entity((EntityType<? extends Mob>)((EntityType)TFEntities.HELMET_CRAB.value())).size(2.0, 2.0).basicData(c -> TwilightInvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.onlyFor(WorldTier.PINNACLE, 2, 0.55f)).constraints(Constraints.forDimension(TWILIGHT_FOREST)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)).stats(mythic, c -> c.enchantChance(0.85f).enchLevels(60, 35).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 100.0f, 140.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.35f, 0.7f).modifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.32f, 0.85f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.65f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)12.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, StepFunction.constant((float)1.85f))));
        this.addBoss("twilight/kobold", b -> TwilightInvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.value())).size(1.5, 1.5).basicData(c -> TwilightInvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(100, 0.1f)).constraints(Constraints.forDimension(TWILIGHT_FOREST)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("twilight/redcap", b -> TwilightInvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)((EntityType)TFEntities.REDCAP.value())).size(1.5, 1.5).basicData(c -> TwilightInvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(100, 0.1f)).constraints(Constraints.forDimension(TWILIGHT_FOREST)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("twilight/redcap_sapper", b -> TwilightInvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)((EntityType)TFEntities.REDCAP_SAPPER.value())).size(1.5, 1.5).basicData(c -> TwilightInvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(100, 0.1f)).constraints(Constraints.forDimension(TWILIGHT_FOREST)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("twilight/skeleton_druid", b -> TwilightInvaderProvider.basicRangedStats(b).entity((EntityType<? extends Mob>)((EntityType)TFEntities.SKELETON_DRUID.value())).size(1.5, 2.5).basicData(c -> TwilightInvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(100, 0.1f)).constraints(Constraints.forDimension(TWILIGHT_FOREST)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("twilight/skeleton", b -> TwilightInvaderProvider.basicRangedStats(b).entity((EntityType<? extends Mob>)EntityType.SKELETON).size(1.5, 2.5).basicData(c -> TwilightInvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(100, 0.1f)).constraints(Constraints.forDimension(TWILIGHT_FOREST)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
    }

    @Override
    protected void addBoss(String name, UnaryOperator<Invader.Builder> builder) {
        this.addConditionally(Apotheosis.loc(name), ((Invader.Builder)builder.apply(Invader.builder())).build(), new ICondition[]{new ModLoadedCondition("twilightforest")});
    }
}

