/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.jei;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.compat.jei.AdventureJEIPlugin;
import dev.shadowsoffire.apotheosis.compat.jei.BasicGemCuttingExtension;
import dev.shadowsoffire.apotheosis.compat.jei.PurityUpgradeExtension;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.BasicGemCuttingRecipe;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.GemCuttingBlock;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.GemCuttingRecipe;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.PurityUpgradeRecipe;
import java.util.IdentityHashMap;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GemCuttingCategory
implements IRecipeCategory<GemCuttingRecipe> {
    public static final ResourceLocation TEXTURES = Apotheosis.loc("textures/gui/gem_cutting_jei.png");
    private static final Map<Class<?>, GemCuttingExtension<?>> EXTENSIONS = new IdentityHashMap();
    private final IDrawable background;
    private final IDrawable icon;

    public GemCuttingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURES, 0, 0, 148, 78).addPadding(0, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Apoth.Blocks.GEM_CUTTING_TABLE.value()));
    }

    public RecipeType<GemCuttingRecipe> getRecipeType() {
        return AdventureJEIPlugin.GEM_CUTTING;
    }

    public Component getTitle() {
        return GemCuttingBlock.NAME;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GemCuttingRecipe recipe, IFocusGroup focuses) {
        GemCuttingExtension<?> ext = EXTENSIONS.get(recipe.getClass());
        if (ext != null) {
            ext.setRecipe(builder, recipe, focuses);
        }
    }

    public static <T extends GemCuttingRecipe> void registerExtension(Class<T> cls, GemCuttingExtension<T> ext) {
        EXTENSIONS.put(cls, ext);
    }

    static {
        GemCuttingCategory.registerExtension(PurityUpgradeRecipe.class, new PurityUpgradeExtension());
        GemCuttingCategory.registerExtension(BasicGemCuttingRecipe.class, new BasicGemCuttingExtension());
    }

    public static interface GemCuttingExtension<T extends GemCuttingRecipe> {
        public void setRecipe(IRecipeLayoutBuilder var1, T var2, IFocusGroup var3);
    }
}

