/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.gateways.tiered_gate;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.SpawnAlgorithms;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvent;

public record TieredGateSettings(WorldTier tier, Gateway.Size size, TextColor color, Holder<SoundEvent> soundtrack, SpawnAlgorithms.SpawnAlgorithm spawnAlgo) {
    public static final Codec<TieredGateSettings> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WorldTier.CODEC.fieldOf("tier").forGetter(TieredGateSettings::tier), (App)Gateway.Size.CODEC.fieldOf("size").forGetter(TieredGateSettings::size), (App)TextColor.CODEC.fieldOf("color").forGetter(TieredGateSettings::color), (App)SoundEvent.CODEC.optionalFieldOf("soundtrack", (Object)GatewayObjects.GATE_AMBIENT).forGetter(TieredGateSettings::soundtrack), (App)SpawnAlgorithms.CODEC.optionalFieldOf("spawn_algorithm", (Object)SpawnAlgorithms.OPEN_FIELD).forGetter(TieredGateSettings::spawnAlgo)).apply((Applicative)inst, TieredGateSettings::new));

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private WorldTier tier = null;
        private Gateway.Size size = null;
        private TextColor color = TextColor.fromRgb((int)0xFFFFFF);
        private Holder<SoundEvent> soundtrack = GatewayObjects.GATE_AMBIENT;
        private SpawnAlgorithms.SpawnAlgorithm spawnAlgo = SpawnAlgorithms.OPEN_FIELD;

        public Builder tier(WorldTier tier) {
            this.tier = tier;
            return this;
        }

        public Builder size(Gateway.Size size) {
            this.size = size;
            return this;
        }

        public Builder color(TextColor color) {
            this.color = color;
            return this;
        }

        public Builder color(int color) {
            this.color = TextColor.fromRgb((int)color);
            return this;
        }

        public Builder soundtrack(Holder<SoundEvent> soundtrack) {
            this.soundtrack = soundtrack;
            return this;
        }

        public Builder spawnAlgo(SpawnAlgorithms.SpawnAlgorithm spawnAlgo) {
            this.spawnAlgo = spawnAlgo;
            return this;
        }

        public TieredGateSettings build() {
            Preconditions.checkNotNull((Object)((Object)this.tier), (Object)"Tier must be set");
            Preconditions.checkNotNull((Object)this.size, (Object)"Size must be set");
            return new TieredGateSettings(this.tier, this.size, this.color, this.soundtrack, this.spawnAlgo);
        }
    }
}

