/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat;

import com.google.common.base.Predicates;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.util.CommonTooltipUtil;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class AdventureHwylaPlugin
implements IWailaPlugin,
IEntityComponentProvider,
IServerDataProvider<EntityAccessor> {
    public void register(IWailaCommonRegistration reg) {
        reg.registerEntityDataProvider((IServerDataProvider)this, LivingEntity.class);
    }

    public void registerClient(IWailaClientRegistration reg) {
        reg.registerEntityComponent((IComponentProvider)this, Entity.class);
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Entity entity = accessor.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (accessor.getServerData().getBoolean("apoth.boss")) {
                ListTag bossAttribs = accessor.getServerData().getList("apoth.modifiers", 10);
                AttributeMap map = living.getAttributes();
                for (Tag t : bossAttribs) {
                    CompoundTag tag = (CompoundTag)t;
                    Holder attrib = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.tryParse((String)tag.getString("id"))).get();
                    map.getInstance(attrib).load(tag);
                }
                accessor.getServerData().remove("apoth.modifiers");
                living.getPersistentData().merge(accessor.getServerData());
                CommonTooltipUtil.appendBossData(living.level(), living, arg_0 -> ((ITooltip)tooltip).add(arg_0));
            }
        }
    }

    public void appendServerData(CompoundTag tag, EntityAccessor access) {
        LivingEntity living;
        Entity entity = access.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getPersistentData().getBoolean("apoth.boss")) {
            tag.putBoolean("apoth.boss", true);
            tag.putString("apoth.boss.rarity", living.getPersistentData().getString("apoth.boss.rarity"));
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                AttributeMap map = living.getAttributes();
                ListTag bossAttribs = new ListTag();
                BuiltInRegistries.ATTRIBUTE.holders().map(arg_0 -> ((AttributeMap)map).getInstance(arg_0)).filter((Predicate<AttributeInstance>)Predicates.notNull()).forEach(inst -> {
                    for (AttributeModifier modif : inst.getModifiers()) {
                        if (!modif.id().getPath().startsWith("apothic_invader_")) continue;
                        bossAttribs.add((Object)inst.save());
                        break;
                    }
                });
                tag.put("apoth.modifiers", (Tag)bossAttribs);
            }
        }
    }

    public ResourceLocation getUid() {
        return Apotheosis.loc("adventure");
    }
}

