/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.woodwevegot.neoforge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.potionstudios.woodwevegot.client.WoodWeveGotClient;
import net.potionstudios.woodwevegot.world.level.block.WWGTrappedChestBlock;
import net.potionstudios.woodwevegot.world.level.block.WWGWoodSet;
import net.potionstudios.woodwevegot.world.level.block.entity.WWGChestBlockEntity;
import net.potionstudios.woodwevegot.world.level.block.entity.WWGTrappedChestBlockEntity;
import org.jetbrains.annotations.NotNull;

@Mod(value="woodwevegot", dist={Dist.CLIENT})
public class WoodWeveGotClientNeoForge {
    public WoodWeveGotClientNeoForge(IEventBus eventBus) {
        eventBus.addListener(event -> WoodWeveGotClient.registerBlockEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1)));
        eventBus.addListener(WoodWeveGotClientNeoForge::registerClientExtensions);
    }

    private static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        WWGWoodSet.getWoodSets().forEach(set -> {
            event.registerItem(WoodWeveGotClientNeoForge.makeItemExtension((Block)set.chest()), new Item[]{set.chest().asItem()});
            event.registerItem(WoodWeveGotClientNeoForge.makeItemExtension((Block)set.trappedChest()), new Item[]{set.trappedChest().asItem()});
        });
    }

    private static IClientItemExtensions makeItemExtension(final Block block) {
        return new IClientItemExtensions(){

            @NotNull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new BlockEntityWithoutLevelRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels()){

                    public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
                        if (block instanceof WWGTrappedChestBlock) {
                            Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)new WWGTrappedChestBlockEntity(BlockPos.ZERO, block.defaultBlockState()), poseStack, buffer, packedLight, packedOverlay);
                        } else {
                            Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)new WWGChestBlockEntity(BlockPos.ZERO, block.defaultBlockState()), poseStack, buffer, packedLight, packedOverlay);
                        }
                    }
                };
            }
        };
    }
}

