/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.woodwevegot.world.level.block;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;
import net.potionstudios.woodwevegot.world.level.block.WWGBarrelBlock;
import net.potionstudios.woodwevegot.world.level.block.WWGBlocks;
import net.potionstudios.woodwevegot.world.level.block.WWGChestBlock;
import net.potionstudios.woodwevegot.world.level.block.WWGTrappedChestBlock;

public class WWGWoodSet {
    private static final ArrayList<WWGWoodSet> woodSets = new ArrayList();
    private final Supplier<BWGWoodSet> woodSet;
    private final Supplier<BarrelBlock> barrel;
    private final Supplier<LadderBlock> ladder;
    private final Supplier<ChestBlock> chest;
    private final Supplier<ChestBlock> trappedChest;

    public WWGWoodSet(Supplier<BWGWoodSet> woodSet) {
        this.woodSet = woodSet;
        this.barrel = WWGBlocks.registerBlockItem(woodSet.get().name() + "_barrel", WWGBarrelBlock::new, 300);
        this.ladder = WWGBlocks.registerBlockItem(woodSet.get().name() + "_ladder", () -> new LadderBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER)), 300);
        this.chest = WWGBlocks.registerChestBlockItem(woodSet.get().name() + "_chest", () -> new WWGChestBlock(((BWGWoodSet)woodSet.get()).name()));
        this.trappedChest = WWGBlocks.registerChestBlockItem(woodSet.get().name() + "_trapped_chest", () -> new WWGTrappedChestBlock(((BWGWoodSet)woodSet.get()).name()));
        woodSets.add(this);
    }

    public BWGWoodSet getWoodSet() {
        return this.woodSet.get();
    }

    public BarrelBlock barrel() {
        return this.barrel.get();
    }

    public LadderBlock ladder() {
        return this.ladder.get();
    }

    public ChestBlock chest() {
        return this.chest.get();
    }

    public ChestBlock trappedChest() {
        return this.trappedChest.get();
    }

    public String name() {
        return this.woodSet.get().name();
    }

    public static ArrayList<WWGWoodSet> getWoodSets() {
        return woodSets;
    }
}

