/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.woodwevegot;

import java.nio.file.Path;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.potionstudios.woodwevegot.WoodWeveGot;

public interface PlatformHandler {
    public static final PlatformHandler PLATFORM_HANDLER = PlatformHandler.load(PlatformHandler.class);

    public Path configPath();

    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String var1, Supplier<BlockEntityType.Builder<T>> var2);

    private static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        WoodWeveGot.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    default public Supplier<Item> createBlockItem(Supplier<? extends Block> block, int burnTime) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties());
    }

    default public Supplier<Item> createChestBlockItem(Supplier<? extends Block> block) {
        return this.createBlockItem(block, 300);
    }

    public <T> Supplier<T> register(Registry<? super T> var1, String var2, Supplier<T> var3);

    public <T> Supplier<Holder.Reference<T>> registerForHolder(Registry<T> var1, String var2, Supplier<T> var3);
}

